/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqualWithinPercentage;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparisonStrategy;

public abstract class Numbers<NUMBER extends Number>
extends Comparables {
    public Numbers() {
    }

    public Numbers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    protected abstract NUMBER zero();

    public void assertIsZero(AssertionInfo info, NUMBER actual) {
        this.assertEqualByComparison(info, (Comparable)actual, (Comparable)this.zero());
    }

    public void assertIsNotZero(AssertionInfo info, NUMBER actual) {
        this.assertNotEqualByComparison(info, (Comparable)actual, (Comparable)this.zero());
    }

    public void assertIsNegative(AssertionInfo info, NUMBER actual) {
        this.assertLessThan(info, (Comparable)actual, (Comparable)this.zero());
    }

    public void assertIsPositive(AssertionInfo info, NUMBER actual) {
        this.assertGreaterThan(info, (Comparable)actual, (Comparable)this.zero());
    }

    public void assertIsNotNegative(AssertionInfo info, NUMBER actual) {
        this.assertGreaterThanOrEqualTo(info, (Comparable)actual, (Comparable)this.zero());
    }

    public void assertIsNotPositive(AssertionInfo info, NUMBER actual) {
        this.assertLessThanOrEqualTo(info, (Comparable)actual, (Comparable)this.zero());
    }

    public void assertIsBetween(AssertionInfo info, NUMBER actual, NUMBER start, NUMBER end) {
        this.assertIsBetween(info, (Comparable)actual, (Comparable)start, (Comparable)end, true, true);
    }

    public void assertIsStrictlyBetween(AssertionInfo info, NUMBER actual, NUMBER start, NUMBER end) {
        this.assertIsBetween(info, (Comparable)actual, (Comparable)start, (Comparable)end, false, false);
    }

    public abstract void assertIsCloseTo(AssertionInfo var1, NUMBER var2, NUMBER var3, Offset<NUMBER> var4);

    public void assertIsCloseToPercentage(AssertionInfo info, NUMBER actual, NUMBER other, Percentage percentage) {
        this.isCloseToPercentageCommonChecks(info, actual, other, percentage);
        Offset<Double> offset = this.computeOffset(other, percentage);
        double absDiff = this.absDiff(actual, other);
        if (absDiff > (Double)offset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinPercentage.shouldBeEqualWithinPercentage(actual, other, percentage, absDiff));
        }
    }

    protected void isCloseToPercentageCommonChecks(AssertionInfo info, NUMBER actual, NUMBER other, Percentage percentage) {
        Numbers.assertNotNull(info, actual);
        CommonValidations.checkPercentageIsNotNull(percentage);
        CommonValidations.checkNumberIsNotNull(other);
    }

    protected double absDiff(NUMBER actual, NUMBER expected) {
        return Math.abs(((Number)expected).doubleValue() - ((Number)actual).doubleValue());
    }

    private Offset<Double> computeOffset(NUMBER referenceValue, Percentage percentage) {
        return Offset.offset(percentage.value * ((Number)referenceValue).doubleValue() / 100.0);
    }
}

