/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.api.DefaultAssertionErrorCollector;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.SoftAssertionsProvider;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.error.AssertionErrorCreator;
import org.assertj.core.internal.Failures;

public abstract class AbstractSoftAssertions
extends DefaultAssertionErrorCollector
implements SoftAssertionsProvider,
InstanceOfAssertFactories {
    protected final SoftProxies proxies = new SoftProxies(this);
    private static final AssertionErrorCreator ASSERTION_ERROR_CREATOR = new AssertionErrorCreator();

    public static void assertAll(AssertionErrorCollector collector) {
        List<AssertionError> errors = collector.assertionErrorsCollected();
        if (!errors.isEmpty()) {
            throw ASSERTION_ERROR_CREATOR.multipleSoftAssertionsError(errors);
        }
    }

    @Override
    public void assertAll() {
        AbstractSoftAssertions.assertAll(this);
    }

    @Override
    public <SELF extends Assert<? extends SELF, ? extends ACTUAL>, ACTUAL> SELF proxy(Class<SELF> assertClass, Class<ACTUAL> actualClass, ACTUAL actual) {
        return this.proxies.createSoftAssertionProxy(assertClass, actualClass, actual);
    }

    public void fail(String failureMessage) {
        AssertionError error = Failures.instance().failure(failureMessage);
        this.collectAssertionError(error);
    }

    public void fail(String failureMessage, Object ... args) {
        AssertionError error = Failures.instance().failure(String.format(failureMessage, args));
        this.collectAssertionError(error);
    }

    public void fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        this.collectAssertionError(error);
    }

    public void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        this.shouldHaveThrown(throwableClass);
    }

    public void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        AssertionError error = Failures.instance().expectedThrowableNotThrown(throwableClass);
        this.collectAssertionError(error);
    }

    @Override
    public List<AssertionError> assertionErrorsCollected() {
        return this.decorateErrorsCollected(super.assertionErrorsCollected());
    }

    public List<Throwable> errorsCollected() {
        return this.decorateErrorsCollected(super.assertionErrorsCollected());
    }

    protected <T extends Throwable> List<T> decorateErrorsCollected(List<? extends T> errors) {
        return this.addLineNumberToErrorMessages(errors);
    }

    private <T extends Throwable> List<T> addLineNumberToErrorMessages(List<? extends T> errors) {
        return errors.stream().map(this::addLineNumberToErrorMessage).collect(Collectors.toList());
    }

    private <T extends Throwable> T addLineNumberToErrorMessage(T error) {
        StackTraceElement testStackTraceElement = this.getFirstStackTraceElementFromTest(error.getStackTrace());
        if (testStackTraceElement != null) {
            try {
                return this.createNewInstanceWithLineNumberInErrorMessage(error, testStackTraceElement);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        return error;
    }

    private <T extends Throwable> T createNewInstanceWithLineNumberInErrorMessage(T error, StackTraceElement testStackTraceElement) throws ReflectiveOperationException {
        Constructor<?> constructor = error.getClass().getConstructor(String.class, Throwable.class);
        Throwable errorWithLineNumber = (Throwable)constructor.newInstance(this.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement), error.getCause());
        errorWithLineNumber.setStackTrace(error.getStackTrace());
        for (Throwable suppressed : error.getSuppressed()) {
            errorWithLineNumber.addSuppressed(suppressed);
        }
        return (T)errorWithLineNumber;
    }

    private String buildErrorMessageWithLineNumber(String originalErrorMessage, StackTraceElement testStackTraceElement) {
        String testClassName = this.simpleClassNameOf(testStackTraceElement);
        String testName = testStackTraceElement.getMethodName();
        int lineNumber = testStackTraceElement.getLineNumber();
        return String.format("%s%nat %s.%s(%s.java:%s)", originalErrorMessage, testClassName, testName, testClassName, lineNumber);
    }

    private String simpleClassNameOf(StackTraceElement testStackTraceElement) {
        String className = testStackTraceElement.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private StackTraceElement getFirstStackTraceElementFromTest(StackTraceElement[] stacktrace) {
        for (StackTraceElement element : stacktrace) {
            String className = element.getClassName();
            if (this.isProxiedAssertionClass(className) || className.startsWith("sun.reflect") || className.startsWith("jdk.internal.reflect") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.eclipse.jdt.internal.junit.") || className.startsWith("org.eclipse.jdt.internal.junit4.") || className.startsWith("org.eclipse.jdt.internal.junit5.") || className.startsWith("com.intellij.junit5.") || className.startsWith("com.intellij.rt.execution.junit.") || className.startsWith("com.intellij.rt.junit.") || className.startsWith("org.apache.maven.surefire") || className.startsWith("org.assertj")) continue;
            return element;
        }
        return null;
    }

    private boolean isProxiedAssertionClass(String className) {
        return className.contains("$ByteBuddy$");
    }
}

