/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Long2DArrays;
import org.assertj.core.util.VisibleForTesting;

public class Long2DArrayAssert
extends Abstract2DArrayAssert<Long2DArrayAssert, long[][], Long> {
    private final Failures failures = Failures.instance();
    @VisibleForTesting
    protected Long2DArrays long2dArrays = Long2DArrays.instance();

    public Long2DArrayAssert(long[][] actual) {
        super(actual, Long2DArrayAssert.class);
    }

    @Override
    public Long2DArrayAssert isDeepEqualTo(long[][] expected) {
        if (this.actual == expected) {
            return (Long2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((long[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((long[][])this.actual).length, expected.length));
        }
        for (int i = 0; i < ((long[][])this.actual).length; ++i) {
            long[] actualSubArray = ((long[][])this.actual)[i];
            long[] expectedSubArray = expected[i];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Long2DArrayAssert)this.myself;
    }

    @Override
    public Long2DArrayAssert isEqualTo(Object expected) {
        return (Long2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.long2dArrays.assertNullOrEmpty(this.info, (long[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.long2dArrays.assertEmpty(this.info, (long[][])this.actual);
    }

    @Override
    public Long2DArrayAssert isNotEmpty() {
        this.long2dArrays.assertNotEmpty(this.info, (long[][])this.actual);
        return (Long2DArrayAssert)this.myself;
    }

    @Override
    public Long2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.long2dArrays.assertHasDimensions(this.info, (long[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Long2DArrayAssert)this.myself;
    }

    @Override
    public Long2DArrayAssert hasSameDimensionsAs(Object array) {
        this.long2dArrays.assertHasSameDimensionsAs(this.info, (long[][])this.actual, array);
        return (Long2DArrayAssert)this.myself;
    }

    public Long2DArrayAssert contains(long[] value, Index index) {
        this.long2dArrays.assertContains(this.info, (long[][])this.actual, value, index);
        return (Long2DArrayAssert)this.myself;
    }

    public Long2DArrayAssert doesNotContain(long[] value, Index index) {
        this.long2dArrays.assertDoesNotContain(this.info, (long[][])this.actual, value, index);
        return (Long2DArrayAssert)this.myself;
    }
}

