/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.ComparableAssert;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractComparableAssert<S extends AbstractComparableAssert<S, A>, A extends Comparable<? super A>>
extends AbstractObjectAssert<S, A>
implements ComparableAssert<S, A> {
    @VisibleForTesting
    Comparables comparables = Comparables.instance();

    protected AbstractComparableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S isEqualByComparingTo(A other) {
        this.comparables.assertEqualByComparison(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isNotEqualByComparingTo(A other) {
        this.comparables.assertNotEqualByComparison(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isLessThan(A other) {
        this.comparables.assertLessThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(A other) {
        this.comparables.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isGreaterThan(A other) {
        this.comparables.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(A other) {
        this.comparables.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        super.usingComparator((Comparator)customComparator);
        this.comparables = new Comparables(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.comparables = Comparables.instance();
        return (S)((AbstractComparableAssert)this.myself);
    }

    @Override
    public S inHexadecimal() {
        return (S)((AbstractComparableAssert)super.inHexadecimal());
    }

    @Override
    public S inBinary() {
        return (S)((AbstractComparableAssert)super.inBinary());
    }
}

