/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Introspection {
    public static PropertyDescriptor getProperty(String propertyName, Object target) {
        Preconditions.checkNotNullOrEmpty(propertyName);
        Preconditions.checkNotNull(target);
        PropertyDescriptor prop = Introspection.getBeanProperty(target.getClass(), propertyName);
        if (prop == null) {
            prop = Introspection.digForDefaultImplementations(target.getClass(), propertyName);
        }
        if (prop != null) {
            return prop;
        }
        throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage(propertyName, target));
    }

    private static PropertyDescriptor digForDefaultImplementations(Class<?> type, String propertyName) {
        for (Class<?> interfaz : type.getInterfaces()) {
            PropertyDescriptor prop = Introspection.getBeanProperty(interfaz, propertyName);
            if (prop == null) {
                prop = Introspection.digForDefaultImplementations(interfaz, propertyName);
            }
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    private static PropertyDescriptor getBeanProperty(Class<?> type, String propertyName) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(type);
        }
        catch (Throwable t) {
            throw new IntrospectionError(String.format("Unable to get BeanInfo for type %s", type.getName()), t);
        }
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    private static String propertyNotFoundErrorMessage(String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property = Strings.quote(propertyName);
        Method getter = Introspection.findGetter(propertyName, target);
        if (getter == null) {
            return String.format("No getter for property %s in %s", property, targetTypeName);
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            return String.format("No public getter for property %s in %s", property, targetTypeName);
        }
        return String.format("Unable to find property %s in %s", property, targetTypeName);
    }

    private static Method findGetter(String propertyName, Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (getter != null) {
            return getter;
        }
        return Introspection.findMethod("is" + capitalized, target);
    }

    private static Method findMethod(String name, Object target) {
        try {
            return target.getClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Introspection() {
    }
}

