/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.Introspection;
import org.assertj.core.util.introspection.IntrospectionError;

public class PropertySupport {
    private static final String SEPARATOR = ".";
    private static final PropertySupport INSTANCE = new PropertySupport();

    public static PropertySupport instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    PropertySupport() {
    }

    public <T> List<T> propertyValues(String propertyName, Class<T> clazz, Iterable<?> target) {
        if (IterableUtil.isNullOrEmpty(target)) {
            return Collections.emptyList();
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            List<Object> propertyValues = this.propertyValues(firstPropertyName, Object.class, target);
            return this.propertyValues(this.nextPropertyNameFrom(propertyName), clazz, propertyValues);
        }
        return this.simplePropertyValues(propertyName, clazz, target);
    }

    public static <T> T propertyValueOf(String propertyName, Object target, Class<T> clazz) {
        return PropertySupport.instance().propertyValueOf(propertyName, clazz, target);
    }

    private <T> List<T> simplePropertyValues(String propertyName, Class<T> clazz, Iterable<?> target) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        for (Object e : target) {
            propertyValues.add(e == null ? null : (Object)this.propertyValue(propertyName, clazz, e));
        }
        return Collections.unmodifiableList(propertyValues);
    }

    private String popPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return propertyNameChain;
        }
        return propertyNameChain.substring(0, propertyNameChain.indexOf(SEPARATOR));
    }

    private String nextPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return "";
        }
        return propertyNameChain.substring(propertyNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNestedProperty(String propertyName) {
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    public <T> T propertyValue(String propertyName, Class<T> clazz, Object target) {
        Method getter = Introspection.getPropertyGetter(propertyName, target);
        try {
            return (T)getter.invoke(target, new Object[0]);
        }
        catch (ClassCastException e) {
            String msg = String.format("Unable to obtain the value of the property <'%s'> from <%s> - wrong property type specified <%s>", propertyName, target, clazz);
            throw new IntrospectionError(msg, e);
        }
        catch (Exception unexpected) {
            String msg = String.format("Unable to obtain the value of the property <'%s'> from <%s>", propertyName, target);
            throw new IntrospectionError(msg, unexpected);
        }
    }

    public <T> T propertyValueOf(String propertyName, Class<T> clazz, Object target) {
        if (propertyName == null) {
            throw new IllegalArgumentException("the property name should not be null.");
        }
        if (target == null) {
            return null;
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            Object propertyValue = this.propertyValue(firstPropertyName, Object.class, target);
            return this.propertyValueOf(this.nextPropertyNameFrom(propertyName), clazz, propertyValue);
        }
        return this.propertyValue(propertyName, clazz, target);
    }

    public List<Object> propertyValues(String fieldOrPropertyName, Iterable<?> objects) {
        return this.propertyValues(fieldOrPropertyName, Object.class, objects);
    }

    public boolean publicGetterExistsFor(String fieldName, Object actual) {
        try {
            Introspection.getPropertyGetter(fieldName, actual);
        }
        catch (IntrospectionError e) {
            return false;
        }
        return true;
    }
}

