/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.proxy.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.awaitility.proxy.CannotCreateProxyException;

class ByteBuddyProxyCreator {
    ByteBuddyProxyCreator() {
    }

    public static Object create(Class<?> targetClass, Class<?> interceptorClass) {
        Class<Object> effectiveTargetClass = targetClass;
        Set<Class<?>> interfacesToImplement = new HashSet();
        if (Modifier.isFinal(targetClass.getModifiers())) {
            if (ByteBuddyProxyCreator.targetClassHasInterfaces(targetClass)) {
                effectiveTargetClass = Object.class;
                interfacesToImplement = ByteBuddyProxyCreator.getInterfaceHierarchy(targetClass);
            } else {
                throw new CannotCreateProxyException(String.format("Cannot create a proxy for class '%s' because it is final and doesn't implement any interfaces.", targetClass.getName()));
            }
        }
        return ByteBuddyProxyCreator.crateForParameters(effectiveTargetClass, interfacesToImplement, targetClass.getClassLoader(), interceptorClass);
    }

    private static Object crateForParameters(Class<?> effectiveTargetClass, Set<Class<?>> interfacesToImplement, ClassLoader classLoader, Class<?> interceptorClass) {
        ArrayList interfacesToImplementAsList = new ArrayList(interfacesToImplement);
        Class proxyType = new ByteBuddy().subclass(effectiveTargetClass).implement(interfacesToImplementAsList).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isFinalizer())).intercept((Implementation)MethodDelegation.to(interceptorClass)).make().load(classLoader).getLoaded();
        return ByteBuddyProxyCreator.instantiate(proxyType);
    }

    private static Object instantiate(Class<?> dynamicType) {
        try {
            return dynamicType.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean targetClassHasInterfaces(Class<?> targetClass) {
        return ByteBuddyProxyCreator.getInterfaceHierarchy(targetClass).size() > 0;
    }

    private static Set<Class<?>> getInterfaceHierarchy(Class<?> targetClass) {
        HashSet interfaces = new HashSet();
        if (targetClass == null || targetClass.equals(Object.class)) {
            return interfaces;
        }
        interfaces.addAll(Arrays.asList(targetClass.getInterfaces()));
        interfaces.addAll(ByteBuddyProxyCreator.getInterfaceHierarchy(targetClass.getSuperclass()));
        return interfaces;
    }
}

