/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.commandhandling.distributed.UnresolvedRoutingKeyPolicy;
import org.axonframework.common.Assert;

public abstract class AbstractRoutingStrategy
implements RoutingStrategy {
    private static final String STATIC_ROUTING_KEY = "unresolved";
    private final UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy;
    private final AtomicLong counter = new AtomicLong(0L);

    public AbstractRoutingStrategy(UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy) {
        Assert.notNull((Object)((Object)unresolvedRoutingKeyPolicy), () -> "unresolvedRoutingKeyPolicy may not be null");
        this.unresolvedRoutingKeyPolicy = unresolvedRoutingKeyPolicy;
    }

    @Override
    public String getRoutingKey(CommandMessage<?> command) {
        String routingKey = this.doResolveRoutingKey(command);
        if (routingKey == null) {
            switch (this.unresolvedRoutingKeyPolicy) {
                case ERROR: {
                    throw new CommandDispatchException(String.format("The command [%s] does not contain a routing key.", command.getCommandName()));
                }
                case RANDOM_KEY: {
                    return Long.toHexString(this.counter.getAndIncrement());
                }
                case STATIC_KEY: {
                    return STATIC_ROUTING_KEY;
                }
            }
            throw new IllegalStateException("The configured UnresolvedRoutingPolicy of " + this.unresolvedRoutingKeyPolicy.name() + " is not supported.");
        }
        return routingKey;
    }

    protected abstract String doResolveRoutingKey(CommandMessage<?> var1);
}

