/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.common.Assert;
import org.axonframework.common.digest.Digester;

public class ConsistentHash {
    private final SortedMap<String, ConsistentHashMember> hashToMember;

    public ConsistentHash() {
        this.hashToMember = Collections.emptySortedMap();
    }

    private ConsistentHash(SortedMap<String, ConsistentHashMember> hashed) {
        this.hashToMember = hashed;
    }

    public Optional<Member> getMember(String routingKey, CommandMessage<?> commandMessage) {
        String hash = ConsistentHash.hash(routingKey);
        SortedMap<String, ConsistentHashMember> tailMap = this.hashToMember.tailMap(hash);
        Iterator<Map.Entry<String, ConsistentHashMember>> tailIterator = tailMap.entrySet().iterator();
        Optional<Member> foundMember = this.findSuitableMember(commandMessage, tailIterator);
        if (!foundMember.isPresent()) {
            Iterator<Map.Entry<String, ConsistentHashMember>> headIterator = this.hashToMember.headMap(hash).entrySet().iterator();
            foundMember = this.findSuitableMember(commandMessage, headIterator);
        }
        return foundMember;
    }

    protected static String hash(String routingKey) {
        return Digester.md5Hex((String)routingKey);
    }

    private Optional<Member> findSuitableMember(CommandMessage<?> commandMessage, Iterator<Map.Entry<String, ConsistentHashMember>> iterator) {
        while (iterator.hasNext()) {
            Map.Entry<String, ConsistentHashMember> entry = iterator.next();
            if (!entry.getValue().commandFilter.test(commandMessage)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Set<Member> getMembers() {
        return Collections.unmodifiableSet(new HashSet<ConsistentHashMember>(this.hashToMember.values()));
    }

    public ConsistentHash with(Member member, int loadFactor, Predicate<? super CommandMessage<?>> commandFilter) {
        Assert.notNull((Object)member, () -> "Member may not be null");
        TreeMap<String, ConsistentHashMember> members = new TreeMap<String, ConsistentHashMember>(this.without((Member)member).hashToMember);
        ConsistentHashMember newMember = new ConsistentHashMember(member, loadFactor, commandFilter);
        newMember.hashes().forEach(h -> members.put((String)h, newMember));
        return new ConsistentHash(members);
    }

    public ConsistentHash without(Member member) {
        Assert.notNull((Object)member, () -> "Member may not be null");
        TreeMap<String, ConsistentHashMember> newHashes = new TreeMap<String, ConsistentHashMember>();
        this.hashToMember.forEach((h, v) -> {
            if (!Objects.equals(v.name(), member.name())) {
                newHashes.put((String)h, (ConsistentHashMember)v);
            }
        });
        return new ConsistentHash(newHashes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsistentHash that = (ConsistentHash)o;
        return Objects.equals(this.hashToMember, that.hashToMember);
    }

    public int hashCode() {
        return Objects.hash(this.hashToMember);
    }

    public static class ConsistentHashMember
    implements Member {
        private final Member member;
        private final int segmentCount;
        private final Predicate<? super CommandMessage<?>> commandFilter;

        private ConsistentHashMember(Member member, int segmentCount, Predicate<? super CommandMessage<?>> commandFilter) {
            this.member = member instanceof ConsistentHashMember ? ((ConsistentHashMember)member).member : member;
            this.segmentCount = segmentCount;
            this.commandFilter = commandFilter;
        }

        @Override
        public String name() {
            return this.member.name();
        }

        @Override
        public void suspect() {
            this.member.suspect();
        }

        public int segmentCount() {
            return this.segmentCount;
        }

        public Set<String> hashes() {
            TreeSet<String> newHashes = new TreeSet<String>();
            for (int t = 0; t < this.segmentCount; ++t) {
                String hash = ConsistentHash.hash(this.name() + " #" + t);
                newHashes.add(hash);
            }
            return newHashes;
        }

        @Override
        public <T> Optional<T> getConnectionEndpoint(Class<T> protocol) {
            return this.member.getConnectionEndpoint(protocol);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsistentHashMember that = (ConsistentHashMember)o;
            return this.segmentCount == that.segmentCount && Objects.equals(this.member, that.member) && Objects.equals(this.commandFilter, that.commandFilter);
        }

        public int hashCode() {
            return Objects.hash(this.member, this.segmentCount, this.commandFilter);
        }
    }
}

