/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.axonframework.commandhandling.distributed.Member;

public class SimpleMember<E>
implements Member {
    private final Consumer<SimpleMember<E>> suspectHandler;
    private final String name;
    private final E endpoint;

    public SimpleMember(String name, E endpoint, Consumer<SimpleMember<E>> suspectHandler) {
        this.name = name;
        this.endpoint = endpoint;
        this.suspectHandler = suspectHandler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> Optional<T> getConnectionEndpoint(Class<T> protocol) {
        if (protocol.isInstance(this.endpoint)) {
            return Optional.of(this.endpoint);
        }
        return Optional.empty();
    }

    @Override
    public void suspect() {
        if (this.suspectHandler != null) {
            this.suspectHandler.accept(this);
        }
    }

    public E endpoint() {
        return this.endpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMember that = (SimpleMember)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.endpoint, that.endpoint);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.endpoint);
    }

    public String toString() {
        return "SimpleMember{name=" + this.name + ", endpoint=" + this.endpoint + '}';
    }
}

