/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.commandfilter;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;

public class DenyCommandNameFilter
implements Predicate<CommandMessage<?>>,
Serializable {
    private final Set<String> commandNames;

    public DenyCommandNameFilter(Set<String> commandNames) {
        this.commandNames = new HashSet<String>(commandNames);
    }

    public DenyCommandNameFilter(String commandName) {
        this.commandNames = Collections.singleton(commandName);
    }

    @Override
    public boolean test(CommandMessage commandMessage) {
        return !this.commandNames.contains(commandMessage.getCommandName());
    }

    @Override
    public Predicate<CommandMessage<?>> and(Predicate<? super CommandMessage<?>> other) {
        if (other instanceof DenyCommandNameFilter) {
            return new DenyCommandNameFilter(Stream.concat(this.commandNames.stream(), ((DenyCommandNameFilter)other).commandNames.stream()).collect(Collectors.toSet()));
        }
        return t -> this.test((CommandMessage)t) && other.test((CommandMessage<?>)t);
    }

    @Override
    public Predicate<CommandMessage<?>> or(Predicate<? super CommandMessage<?>> other) {
        if (other instanceof DenyCommandNameFilter) {
            return new DenyCommandNameFilter(this.commandNames.stream().filter(((DenyCommandNameFilter)other).commandNames::contains).collect(Collectors.toSet()));
        }
        return t -> this.test((CommandMessage)t) || other.test((CommandMessage<?>)t);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenyCommandNameFilter that = (DenyCommandNameFilter)o;
        return Objects.equals(this.commandNames, that.commandNames);
    }

    public int hashCode() {
        return Objects.hash(this.commandNames);
    }

    public String toString() {
        return "DenyCommandNameFilter{commandNames=" + this.commandNames + '}';
    }
}

