/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.MessageSerializer;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.jgroups.util.Streamable;

public class DispatchMessage
implements Streamable,
Externalizable {
    private static final long serialVersionUID = -8792911964758889674L;
    private String commandName;
    private String commandIdentifier;
    private boolean expectReply;
    private String payloadType;
    private String payloadRevision;
    private byte[] serializedPayload;
    private byte[] serializedMetaData;

    public DispatchMessage() {
    }

    public DispatchMessage(CommandMessage<?> commandMessage, Serializer serializer, boolean expectReply) {
        this.commandIdentifier = commandMessage.getIdentifier();
        this.expectReply = expectReply;
        SerializedObject payload = MessageSerializer.serializePayload(commandMessage, (Serializer)serializer, byte[].class);
        SerializedObject metaData = MessageSerializer.serializeMetaData(commandMessage, (Serializer)serializer, byte[].class);
        this.payloadType = payload.getType().getName();
        this.payloadRevision = payload.getType().getRevision();
        this.serializedPayload = (byte[])payload.getData();
        this.serializedMetaData = (byte[])metaData.getData();
        this.commandName = commandMessage.getCommandName();
    }

    public boolean isExpectReply() {
        return this.expectReply;
    }

    public CommandMessage<?> getCommandMessage(Serializer serializer) {
        Object payload = serializer.deserialize((SerializedObject)new SimpleSerializedObject((Object)this.serializedPayload, byte[].class, this.payloadType, this.payloadRevision));
        MetaData metaData = (MetaData)serializer.deserialize((SerializedObject)new SerializedMetaData((Object)this.serializedMetaData, byte[].class));
        return new GenericCommandMessage((Message)new GenericMessage(this.commandIdentifier, payload, (Map)metaData), this.commandName);
    }

    public String getCommandIdentifier() {
        return this.commandIdentifier;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.commandName);
        out.writeUTF(this.commandIdentifier);
        out.writeBoolean(this.expectReply);
        out.writeUTF(this.payloadType);
        out.writeUTF(this.payloadRevision == null ? "_null" : this.payloadRevision);
        out.writeInt(this.serializedPayload.length);
        out.write(this.serializedPayload);
        out.writeInt(this.serializedMetaData.length);
        out.write(this.serializedMetaData);
    }

    public void readFrom(DataInput in) throws IOException {
        this.commandName = in.readUTF();
        this.commandIdentifier = in.readUTF();
        this.expectReply = in.readBoolean();
        this.payloadType = in.readUTF();
        this.payloadRevision = in.readUTF();
        if ("_null".equals(this.payloadRevision)) {
            this.payloadRevision = null;
        }
        this.serializedPayload = new byte[in.readInt()];
        in.readFully(this.serializedPayload);
        this.serializedMetaData = new byte[in.readInt()];
        in.readFully(this.serializedMetaData);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readFrom(in);
    }
}

