/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.jgroups.util.Streamable;

public class ReplyMessage
implements Streamable,
Externalizable {
    private static final long serialVersionUID = 6955710928767199410L;
    private static final String NULL = "_null";
    private String commandIdentifier;
    private boolean success;
    private String resultType;
    private String resultRevision;
    private byte[] serializedResult;

    public ReplyMessage() {
    }

    public ReplyMessage(String commandIdentifier, Object returnValue, Throwable error, Serializer serializer) {
        boolean bl = this.success = error == null;
        SerializedObject result = this.success ? (returnValue == null ? null : serializer.serialize(returnValue, byte[].class)) : serializer.serialize((Object)error, byte[].class);
        this.commandIdentifier = commandIdentifier;
        if (result != null) {
            this.resultType = result.getType().getName();
            this.resultRevision = result.getType().getRevision();
            this.serializedResult = (byte[])result.getData();
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Object getReturnValue(Serializer serializer) {
        if (!this.success || this.resultType == null) {
            return null;
        }
        return this.deserializeResult(serializer);
    }

    public Throwable getError(Serializer serializer) {
        if (this.success) {
            return null;
        }
        return (Throwable)this.deserializeResult(serializer);
    }

    private Object deserializeResult(Serializer serializer) {
        return serializer.deserialize((SerializedObject)new SimpleSerializedObject((Object)this.serializedResult, byte[].class, this.resultType, this.resultRevision));
    }

    public String getCommandIdentifier() {
        return this.commandIdentifier;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.commandIdentifier);
        out.writeBoolean(this.success);
        if (this.resultType == null) {
            out.writeUTF(NULL);
        } else {
            out.writeUTF(this.resultType);
            out.writeUTF(this.resultRevision == null ? NULL : this.resultRevision);
            out.writeInt(this.serializedResult.length);
            out.write(this.serializedResult);
        }
    }

    public void readFrom(DataInput in) throws IOException {
        this.commandIdentifier = in.readUTF();
        this.success = in.readBoolean();
        this.resultType = in.readUTF();
        if (NULL.equals(this.resultType)) {
            this.resultType = null;
        } else {
            this.resultRevision = in.readUTF();
            if (NULL.equals(this.resultRevision)) {
                this.resultRevision = null;
            }
            this.serializedResult = new byte[in.readInt()];
            in.readFully(this.serializedResult);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readFrom(in);
    }
}

