/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AggregateFactory;

public abstract class AbstractAggregateFactory<T>
implements AggregateFactory<T> {
    private final Class<T> aggregateBaseType;

    protected AbstractAggregateFactory(Class<T> aggregateBaseType) {
        this.aggregateBaseType = aggregateBaseType;
    }

    @Override
    public final T createAggregateRoot(String aggregateIdentifier, DomainEventMessage<?> firstEvent) {
        Object aggregate = this.aggregateBaseType.isAssignableFrom(firstEvent.getPayloadType()) ? firstEvent.getPayload() : this.doCreateAggregate(aggregateIdentifier, firstEvent);
        return (T)this.postProcessInstance(aggregate);
    }

    protected T postProcessInstance(T aggregate) {
        return aggregate;
    }

    protected abstract T doCreateAggregate(String var1, DomainEventMessage var2);

    @Override
    public Class<T> getAggregateType() {
        return this.aggregateBaseType;
    }
}

