/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.serialization.SerializedObject;

public class HeaderUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private HeaderUtils() {
    }

    public static Long asLong(byte[] value) {
        return value != null ? Long.valueOf(ByteBuffer.wrap(value).getLong()) : null;
    }

    public static Long valueAsLong(Headers headers, String key) {
        return HeaderUtils.asLong(HeaderUtils.value(headers, key));
    }

    public static String asString(byte[] value) {
        return value != null ? new String(value, UTF_8) : null;
    }

    public static String valueAsString(Headers headers, String key) {
        return HeaderUtils.asString(HeaderUtils.value(headers, key));
    }

    public static String valueAsString(Headers headers, String key, String defaultValue) {
        return Objects.toString(HeaderUtils.asString(HeaderUtils.value(headers, key)), defaultValue);
    }

    public static byte[] value(Headers headers, String key) {
        Assert.isTrue((headers != null ? 1 : 0) != 0, () -> "header may not be null");
        Header header = headers.lastHeader(key);
        return header != null ? header.value() : null;
    }

    public static byte[] toBytes(Number value) {
        if (value instanceof Short) {
            return HeaderUtils.toBytes((Short)value);
        }
        if (value instanceof Integer) {
            return HeaderUtils.toBytes((Integer)value);
        }
        if (value instanceof Long) {
            return HeaderUtils.toBytes((Long)value);
        }
        if (value instanceof Float) {
            return HeaderUtils.toBytes((Float)value);
        }
        if (value instanceof Double) {
            return HeaderUtils.toBytes((Double)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to bytes");
    }

    public static void addHeader(Headers target, String key, Object value) {
        Assert.notNull((Object)target, () -> "target may not be null");
        if (value instanceof Instant) {
            target.add(key, HeaderUtils.toBytes((Number)((Instant)value).toEpochMilli()));
        } else if (value instanceof Number) {
            target.add(key, HeaderUtils.toBytes((Number)value));
        } else if (value instanceof String) {
            target.add(key, ((String)value).getBytes(UTF_8));
        } else if (value == null) {
            target.add(key, null);
        } else {
            target.add(key, value.toString().getBytes(UTF_8));
        }
    }

    public static Set<String> keys(Headers headers) {
        Assert.notNull((Object)headers, () -> "header may not be null");
        HashSet<String> keys = new HashSet<String>();
        headers.forEach(header -> keys.add(header.key()));
        return keys;
    }

    public static String generateMetadataKey(String key) {
        return "axon-metadata-" + key;
    }

    public static String extractKey(String metadataKey) {
        Assert.isTrue((metadataKey != null && metadataKey.startsWith("axon-metadata-") ? 1 : 0) != 0, () -> "Invalid key");
        return metadataKey.substring("axon-metadata-".length());
    }

    public static Map<String, Object> extractAxonMetadata(Headers target) {
        Assert.notNull((Object)target, () -> "header may not be null");
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        target.forEach(header -> {
            String key = header.key();
            if (HeaderUtils.isValidMetadataKey(key)) {
                metaData.put(HeaderUtils.extractKey(key), HeaderUtils.asString(header.value()));
            }
        });
        return metaData;
    }

    public static Headers toHeaders(EventMessage<?> eventMessage, SerializedObject<byte[]> serializedObject, BiFunction<String, Object, RecordHeader> headerValueMapper) {
        Assert.notNull(eventMessage, () -> "Event message may not be null");
        Assert.notNull(serializedObject, () -> "Serialized Object may not be null");
        Assert.notNull(headerValueMapper, () -> "function to map header key and value may not be null");
        RecordHeaders headers = new RecordHeaders();
        HeaderUtils.addAxonHeaders((Headers)headers, eventMessage, serializedObject, headerValueMapper);
        return headers;
    }

    public static BiFunction<String, Object, RecordHeader> byteMapper() {
        return (key, value) -> value instanceof byte[] ? new RecordHeader(key, (byte[])value) : new RecordHeader(key, value == null ? null : value.toString().getBytes(UTF_8));
    }

    private static boolean isValidMetadataKey(String key) {
        return key.startsWith("axon-metadata-");
    }

    private static void addAxonHeaders(Headers target, EventMessage<?> eventMessage, SerializedObject<byte[]> serializedObject, BiFunction<String, Object, RecordHeader> headerValueMapper) {
        eventMessage.getMetaData().forEach((k, v) -> target.add((Header)headerValueMapper.apply(HeaderUtils.generateMetadataKey(k), v)));
        org.axonframework.messaging.Headers.defaultHeaders(eventMessage, serializedObject).forEach((k, v) -> HeaderUtils.addHeader(target, k, v));
    }

    private static byte[] toBytes(Short value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value);
        return buffer.array();
    }

    private static byte[] toBytes(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    private static byte[] toBytes(Long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    private static byte[] toBytes(Float value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(value.floatValue());
        return buffer.array();
    }

    private static byte[] toBytes(Double value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(value);
        return buffer.array();
    }
}

