/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling.consumer;

import java.util.Comparator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.kafka.eventhandling.consumer.KafkaMetadataProvider;
import org.axonframework.kafka.eventhandling.consumer.KafkaTrackingToken;

public class KafkaEventMessage
implements KafkaMetadataProvider<TrackedEventMessage<?>>,
Comparable<KafkaEventMessage> {
    private static final Comparator<KafkaEventMessage> COMPARATOR = Comparator.comparing(KafkaEventMessage::timestamp).thenComparing(KafkaEventMessage::partition).thenComparing(KafkaEventMessage::offset);
    private final TrackedEventMessage<?> eventMessage;
    private final int partition;
    private final long offset;
    private final long timestamp;

    public KafkaEventMessage(TrackedEventMessage<?> eventMessage, int partition, long offset, long timestamp) {
        Assert.notNull(eventMessage, () -> "Event may not be null");
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
        this.eventMessage = eventMessage;
    }

    public static KafkaEventMessage from(EventMessage<?> eventMessage, ConsumerRecord<?, ?> record, KafkaTrackingToken token) {
        return new KafkaEventMessage(EventUtils.asTrackedEventMessage(eventMessage, (TrackingToken)token), record.partition(), record.offset(), record.timestamp());
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public TrackedEventMessage<?> value() {
        return this.eventMessage;
    }

    @Override
    public int compareTo(KafkaEventMessage other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return "KafkaEventMessage{eventMessage=" + this.eventMessage + ", partition=" + this.partition + ", offset=" + this.offset + ", timestamp=" + this.timestamp + '}';
    }
}

