/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling.consumer;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.eventstore.TrackingEventStream;
import org.axonframework.kafka.eventhandling.consumer.Buffer;
import org.axonframework.kafka.eventhandling.consumer.KafkaEventMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageStream
implements TrackingEventStream {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageStream.class);
    private final Buffer<KafkaEventMessage> buffer;
    private final Runnable closeHandler;
    private KafkaEventMessage peekEvent;

    public KafkaMessageStream(Buffer<KafkaEventMessage> buffer, Runnable closeHandler) {
        Assert.notNull(buffer, () -> "Buffer may not be null");
        this.closeHandler = closeHandler;
        this.buffer = buffer;
    }

    public Optional<TrackedEventMessage<?>> peek() {
        return Optional.ofNullable(this.peekEvent == null && !this.hasNextAvailable(0, TimeUnit.NANOSECONDS) ? null : this.peekEvent.value());
    }

    public boolean hasNextAvailable(int timeout, TimeUnit unit) {
        try {
            return this.peekEvent != null || (this.peekEvent = this.buffer.poll(timeout, unit)) != null;
        }
        catch (InterruptedException e) {
            logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public TrackedEventMessage<?> nextAvailable() {
        try {
            TrackedEventMessage<?> trackedEventMessage = this.peekEvent == null ? this.buffer.take().value() : this.peekEvent.value();
            return trackedEventMessage;
        }
        catch (InterruptedException e) {
            logger.warn("Consumer thread was interrupted. Returning thread to event processor.", (Throwable)e);
            Thread.currentThread().interrupt();
            TrackedEventMessage<?> trackedEventMessage = null;
            return trackedEventMessage;
        }
        finally {
            this.peekEvent = null;
        }
    }

    public void close() {
        this.closeHandler.run();
    }
}

