/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.Assert;
import org.axonframework.common.MemberAccessibilityCallback;
import org.axonframework.common.ObjectUtils;

public abstract class ReflectionUtils {
    private static final Map<Type, Class<?>> primitiveWrapperTypeMap = new HashMap(8);

    public static <R> R getFieldValue(Field field, Object object) {
        ReflectionUtils.ensureAccessible(field);
        try {
            return (R)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalStateException("Unable to access field for getting.", ex);
        }
    }

    public static <T> void setFieldValue(Field field, Object object, T value) {
        ReflectionUtils.ensureAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unable to access field for setting.", ex);
        }
    }

    public static Class<?> declaringClass(Class<?> instanceClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return instanceClass.getMethod(methodName, parameterTypes).getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasEqualsMethod(Class<?> type) {
        return !Object.class.equals(ReflectionUtils.declaringClass(type, "equals", Object.class));
    }

    public static boolean explicitlyUnequal(Object value, Object otherValue) {
        if (value == otherValue) {
            return false;
        }
        if (value == null || otherValue == null) {
            return true;
        }
        if (value instanceof Comparable) {
            return ((Comparable)value).compareTo(otherValue) != 0;
        }
        if (ReflectionUtils.hasEqualsMethod(value.getClass())) {
            return !value.equals(otherValue);
        }
        return false;
    }

    public static <T extends AccessibleObject> T ensureAccessible(T member) {
        if (!ReflectionUtils.isAccessible(member)) {
            AccessController.doPrivileged(new MemberAccessibilityCallback(member));
        }
        return member;
    }

    public static boolean isAccessible(AccessibleObject member) {
        return member.isAccessible() || member instanceof Member && ReflectionUtils.isNonFinalPublicMember((Member)((Object)member));
    }

    public static boolean isNonFinalPublicMember(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers()) && !Modifier.isFinal(member.getModifiers());
    }

    public static Iterable<Field> fieldsOf(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Class<?> currentClazz = clazz;
        do {
            fields.addAll(Arrays.asList(currentClazz.getDeclaredFields()));
        } while ((currentClazz = currentClazz.getSuperclass()) != null);
        return Collections.unmodifiableList(fields);
    }

    public static Method methodOf(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return clazz.getMethod(methodName, parameterTypes);
    }

    public static Iterable<Method> methodsOf(Class<?> clazz) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Class<?> currentClazz = clazz;
        do {
            methods.addAll(Arrays.asList(currentClazz.getDeclaredMethods()));
            ReflectionUtils.addMethodsOnDeclaredInterfaces(currentClazz, methods);
        } while ((currentClazz = currentClazz.getSuperclass()) != null);
        return Collections.unmodifiableList(methods);
    }

    public static Class<?> resolvePrimitiveWrapperType(Class<?> primitiveType) {
        Assert.notNull(primitiveType, () -> "primitiveType may not be null");
        Assert.isTrue(primitiveType.isPrimitive(), () -> "primitiveType is not actually primitive: " + primitiveType);
        Class<?> primitiveWrapperType = primitiveWrapperTypeMap.get(primitiveType);
        Assert.notNull(primitiveWrapperType, () -> "no wrapper found for primitiveType: " + primitiveType);
        return primitiveWrapperType;
    }

    public static Type resolvePrimitiveWrapperTypeIfPrimitive(Type type) {
        Assert.notNull(type, () -> "type may not be null");
        return ObjectUtils.getOrDefault(primitiveWrapperTypeMap.get(type), type);
    }

    private static void addMethodsOnDeclaredInterfaces(Class<?> currentClazz, List<Method> methods) {
        for (Class<?> iface : currentClazz.getInterfaces()) {
            methods.addAll(Arrays.asList(iface.getDeclaredMethods()));
            ReflectionUtils.addMethodsOnDeclaredInterfaces(iface, methods);
        }
    }

    public static boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    public static Optional<Class<?>> resolveGenericType(Field field, int genericTypeIndex) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType) || ((ParameterizedType)genericType).getActualTypeArguments().length <= genericTypeIndex) {
            return Optional.empty();
        }
        return Optional.of((Class)((ParameterizedType)genericType).getActualTypeArguments()[genericTypeIndex]);
    }

    private ReflectionUtils() {
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperTypeMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperTypeMap.put(Character.TYPE, Character.class);
        primitiveWrapperTypeMap.put(Double.TYPE, Double.class);
        primitiveWrapperTypeMap.put(Float.TYPE, Float.class);
        primitiveWrapperTypeMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperTypeMap.put(Long.TYPE, Long.class);
        primitiveWrapperTypeMap.put(Short.TYPE, Short.class);
    }
}

