/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import java.lang.reflect.Field;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessException;

public class DirectlyAccessedProperty<T>
implements Property<T> {
    private final Field field;
    private final String property;

    public DirectlyAccessedProperty(Field field, String property) {
        this.field = field;
        this.property = property;
    }

    @Override
    public <V> V getValue(T target) {
        try {
            return (V)this.field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(String.format("Failed to get value of '%s' in '%s'. Property should be accessible", this.property, target.getClass().getName()), e);
        }
    }
}

