/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.CachingSupplier;

public class GenericEventMessage<T>
extends MessageDecorator<T>
implements EventMessage<T> {
    private static final long serialVersionUID = -8296350547944518544L;
    private final Supplier<Instant> timestampSupplier;
    public static Clock clock = Clock.systemUTC();

    public static <T> EventMessage<T> asEventMessage(Object event) {
        if (EventMessage.class.isInstance(event)) {
            return (EventMessage)event;
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return new GenericEventMessage<T>(message, clock.instant());
        }
        return new GenericEventMessage<Object>(new GenericMessage<Object>(event), clock.instant());
    }

    public GenericEventMessage(T payload) {
        this(payload, MetaData.emptyInstance());
    }

    public GenericEventMessage(T payload, Map<String, ?> metaData) {
        this(new GenericMessage<T>(payload, metaData), clock.instant());
    }

    public GenericEventMessage(String identifier, T payload, Map<String, ?> metaData, Instant timestamp) {
        this(new GenericMessage<T>(identifier, payload, metaData), timestamp);
    }

    public GenericEventMessage(Message<T> delegate, Supplier<Instant> timestampSupplier) {
        super(delegate);
        this.timestampSupplier = CachingSupplier.of(timestampSupplier);
    }

    protected GenericEventMessage(Message<T> delegate, Instant timestamp) {
        this(delegate, CachingSupplier.of(timestamp));
    }

    @Override
    public Instant getTimestamp() {
        return this.timestampSupplier.get();
    }

    @Override
    public GenericEventMessage<T> withMetaData(Map<String, ?> metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericEventMessage(this.getDelegate().withMetaData(metaData), this.timestampSupplier);
    }

    @Override
    public GenericEventMessage<T> andMetaData(Map<String, ?> metaData) {
        if (metaData == null || metaData.isEmpty() || this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericEventMessage(this.getDelegate().andMetaData(metaData), this.timestampSupplier);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", timestamp='").append(this.getTimestamp().toString());
    }

    @Override
    protected String describeType() {
        return "GenericEventMessage";
    }
}

