/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerComparator;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotatedHandlerInspector<T> {
    private final Class<T> inspectedType;
    private final ParameterResolverFactory parameterResolverFactory;
    private final Map<Class<?>, AnnotatedHandlerInspector> registry;
    private final List<AnnotatedHandlerInspector<? super T>> superClassInspectors;
    private final List<MessageHandlingMember<? super T>> handlers;
    private final HandlerDefinition handlerDefinition;

    private AnnotatedHandlerInspector(Class<T> inspectedType, List<AnnotatedHandlerInspector<? super T>> superClassInspectors, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector> registry) {
        this.inspectedType = inspectedType;
        this.parameterResolverFactory = parameterResolverFactory;
        this.registry = registry;
        this.superClassInspectors = new ArrayList<AnnotatedHandlerInspector<T>>(superClassInspectors);
        this.handlers = new ArrayList<MessageHandlingMember<? super T>>();
        this.handlerDefinition = handlerDefinition;
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType) {
        return AnnotatedHandlerInspector.inspectType(handlerType, ClasspathParameterResolverFactory.forClass(handlerType));
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType, ParameterResolverFactory parameterResolverFactory) {
        return AnnotatedHandlerInspector.inspectType(handlerType, parameterResolverFactory, ClasspathHandlerDefinition.forClass(handlerType));
    }

    public static <T> AnnotatedHandlerInspector<T> inspectType(Class<? extends T> handlerType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return AnnotatedHandlerInspector.createInspector(handlerType, parameterResolverFactory, handlerDefinition, new HashMap());
    }

    private static <T> AnnotatedHandlerInspector<T> createInspector(Class<? extends T> inspectedType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector> registry) {
        if (!registry.containsKey(inspectedType)) {
            registry.put(inspectedType, AnnotatedHandlerInspector.initialize(inspectedType, parameterResolverFactory, handlerDefinition, registry));
        }
        return registry.get(inspectedType);
    }

    private static <T> AnnotatedHandlerInspector<T> initialize(Class<T> inspectedType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Map<Class<?>, AnnotatedHandlerInspector> registry) {
        ArrayList<AnnotatedHandlerInspector<T>> parents = new ArrayList<AnnotatedHandlerInspector<T>>();
        for (Class<?> iFace : inspectedType.getInterfaces()) {
            parents.add(AnnotatedHandlerInspector.createInspector(iFace, parameterResolverFactory, handlerDefinition, registry));
        }
        if (inspectedType.getSuperclass() != null && !Object.class.equals(inspectedType.getSuperclass())) {
            parents.add(AnnotatedHandlerInspector.createInspector(inspectedType.getSuperclass(), parameterResolverFactory, handlerDefinition, registry));
        }
        AnnotatedHandlerInspector<? super T> inspector = new AnnotatedHandlerInspector<T>(inspectedType, parents, parameterResolverFactory, handlerDefinition, registry);
        super.initializeMessageHandlers(parameterResolverFactory, handlerDefinition);
        return inspector;
    }

    private void initializeMessageHandlers(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        for (Method method : this.inspectedType.getDeclaredMethods()) {
            handlerDefinition.createHandler(this.inspectedType, method, parameterResolverFactory).ifPresent(this::registerHandler);
        }
        for (Executable executable : this.inspectedType.getDeclaredConstructors()) {
            handlerDefinition.createHandler(this.inspectedType, executable, parameterResolverFactory).ifPresent(this::registerHandler);
        }
        this.superClassInspectors.forEach(sci -> this.handlers.addAll(sci.getHandlers()));
        this.handlers.sort(HandlerComparator.instance());
    }

    private void registerHandler(MessageHandlingMember<T> handler) {
        this.handlers.add(handler);
    }

    public <C> AnnotatedHandlerInspector<C> inspect(Class<? extends C> entityType) {
        return AnnotatedHandlerInspector.createInspector(entityType, this.parameterResolverFactory, this.handlerDefinition, this.registry);
    }

    public List<MessageHandlingMember<? super T>> getHandlers() {
        return this.handlers;
    }
}

