/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;

public class UpcastedEventRepresentation<T>
implements IntermediateEventRepresentation {
    private final SerializedType outputType;
    private final IntermediateEventRepresentation source;
    private final Function<T, T> upcastFunction;
    private final Function<MetaData, MetaData> metaDataUpcastFunction;
    private final Class<T> requiredType;
    private final Converter converter;
    private LazyDeserializingObject<MetaData> metaData;

    public UpcastedEventRepresentation(SerializedType outputType, IntermediateEventRepresentation source, Function<T, T> upcastFunction, Function<MetaData, MetaData> metaDataUpcastFunction, Class<T> requiredType, Converter converter) {
        this.outputType = outputType;
        this.source = source;
        this.upcastFunction = upcastFunction;
        this.metaDataUpcastFunction = metaDataUpcastFunction;
        this.requiredType = requiredType;
        this.converter = converter;
    }

    public <S> IntermediateEventRepresentation upcast(SerializedType outputType, Class<S> expectedRepresentationType, Function<S, S> upcastFunction, Function<MetaData, MetaData> metaDataUpcastFunction) {
        return new UpcastedEventRepresentation<S>(outputType, this, upcastFunction, metaDataUpcastFunction, expectedRepresentationType, this.converter);
    }

    @Override
    public SerializedType getType() {
        return this.outputType;
    }

    public SerializedObject<T> getData() {
        SerializedObject<T> serializedInput = this.converter.convert(this.source.getData(), this.requiredType);
        return new SimpleSerializedObject<T>(this.upcastFunction.apply(serializedInput.getData()), this.requiredType, this.getType());
    }

    @Override
    public <D> SerializedObject<D> getData(Class<D> requiredType) {
        return this.converter.convert(this.getData(), requiredType);
    }

    @Override
    public String getMessageIdentifier() {
        return this.source.getMessageIdentifier();
    }

    @Override
    public Optional<String> getAggregateType() {
        return this.source.getAggregateType();
    }

    @Override
    public Optional<String> getAggregateIdentifier() {
        return this.source.getAggregateIdentifier();
    }

    @Override
    public Optional<Long> getSequenceNumber() {
        return this.source.getSequenceNumber();
    }

    @Override
    public Optional<TrackingToken> getTrackingToken() {
        return this.source.getTrackingToken();
    }

    @Override
    public Instant getTimestamp() {
        return this.source.getTimestamp();
    }

    @Override
    public LazyDeserializingObject<MetaData> getMetaData() {
        if (this.metaData == null) {
            this.metaData = new LazyDeserializingObject<MetaData>(this.metaDataUpcastFunction.apply(this.source.getMetaData().getObject()));
        }
        return this.metaData;
    }
}

