/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.monitoring.MessageMonitor;

public class MonitorAwareCallback<C, R>
implements CommandCallback<C, R> {
    private final CommandCallback<C, R> delegate;
    private final MessageMonitor.MonitorCallback messageMonitorCallback;

    public MonitorAwareCallback(CommandCallback<C, R> delegate, MessageMonitor.MonitorCallback messageMonitorCallback) {
        this.delegate = delegate;
        this.messageMonitorCallback = messageMonitorCallback;
    }

    @Override
    public void onResult(CommandMessage<? extends C> commandMessage, CommandResultMessage<? extends R> commandResultMessage) {
        if (commandResultMessage.isExceptional()) {
            this.messageMonitorCallback.reportFailure(commandResultMessage.exceptionResult());
        } else {
            this.messageMonitorCallback.reportSuccess();
        }
        if (this.delegate != null) {
            this.delegate.onResult(commandMessage, commandResultMessage);
        }
    }
}

