/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.axonframework.common.property.Property;

public abstract class PropertyAccessStrategy
implements Comparable<PropertyAccessStrategy> {
    private static final ServiceLoader<PropertyAccessStrategy> LOADER = ServiceLoader.load(PropertyAccessStrategy.class);
    private static final SortedSet<PropertyAccessStrategy> STRATEGIES = new ConcurrentSkipListSet<PropertyAccessStrategy>();

    public static void register(PropertyAccessStrategy strategy) {
        STRATEGIES.add(strategy);
    }

    public static void unregister(PropertyAccessStrategy strategy) {
        STRATEGIES.remove(strategy);
    }

    public static <T> Property<T> getProperty(Class<? extends T> targetClass, String propertyName) {
        Property<? extends T> property = null;
        Iterator strategies = STRATEGIES.iterator();
        while (property == null && strategies.hasNext()) {
            property = ((PropertyAccessStrategy)strategies.next()).propertyFor(targetClass, propertyName);
        }
        return property;
    }

    @Override
    public final int compareTo(PropertyAccessStrategy o) {
        if (o == this) {
            return 0;
        }
        int diff = o.getPriority() - this.getPriority();
        if (diff == 0) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return diff;
    }

    protected abstract int getPriority();

    protected abstract <T> Property<T> propertyFor(Class<? extends T> var1, String var2);

    static {
        for (PropertyAccessStrategy factory : LOADER) {
            STRATEGIES.add(factory);
        }
    }
}

