/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.Registration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public abstract class AbstractDeadlineManager
implements DeadlineManager {
    private final List<MessageDispatchInterceptor<? super DeadlineMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final List<MessageHandlerInterceptor<? super DeadlineMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();

    protected void runOnPrepareCommitOrNow(Runnable deadlineCall) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().onPrepareCommit(unitOfWork -> deadlineCall.run());
        } else {
            deadlineCall.run();
        }
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super DeadlineMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super DeadlineMessage<?>> handlerInterceptor) {
        this.handlerInterceptors.add(handlerInterceptor);
        return () -> this.handlerInterceptors.remove(handlerInterceptor);
    }

    protected List<MessageDispatchInterceptor<? super DeadlineMessage<?>>> dispatchInterceptors() {
        return Collections.unmodifiableList(this.dispatchInterceptors);
    }

    protected List<MessageHandlerInterceptor<? super DeadlineMessage<?>>> handlerInterceptors() {
        return Collections.unmodifiableList(this.handlerInterceptors);
    }

    protected <T> DeadlineMessage<T> processDispatchInterceptors(DeadlineMessage<T> message) {
        DeadlineMessage<T> intercepted = message;
        for (MessageDispatchInterceptor<DeadlineMessage<?>> interceptor : this.dispatchInterceptors()) {
            intercepted = interceptor.handle(intercepted);
        }
        return intercepted;
    }
}

