/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.util.Map;
import java.util.Optional;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class ConvertingResponseMessage<R>
implements QueryResponseMessage<R> {
    private final ResponseType<R> expectedResponseType;
    private final QueryResponseMessage<?> responseMessage;

    public ConvertingResponseMessage(ResponseType<R> expectedResponseType, QueryResponseMessage<?> responseMessage) {
        this.expectedResponseType = expectedResponseType;
        this.responseMessage = responseMessage;
    }

    @Override
    public <S> SerializedObject<S> serializePayload(Serializer serializer, Class<S> expectedRepresentation) {
        return this.responseMessage.serializePayload(serializer, expectedRepresentation);
    }

    @Override
    public <T> SerializedObject<T> serializeExceptionResult(Serializer serializer, Class<T> expectedRepresentation) {
        return this.responseMessage.serializeExceptionResult(serializer, expectedRepresentation);
    }

    @Override
    public <R1> SerializedObject<R1> serializeMetaData(Serializer serializer, Class<R1> expectedRepresentation) {
        return this.responseMessage.serializeMetaData(serializer, expectedRepresentation);
    }

    @Override
    public boolean isExceptional() {
        return this.responseMessage.isExceptional();
    }

    @Override
    public Optional<Throwable> optionalExceptionResult() {
        return this.responseMessage.optionalExceptionResult();
    }

    @Override
    public String getIdentifier() {
        return this.responseMessage.getIdentifier();
    }

    @Override
    public MetaData getMetaData() {
        return this.responseMessage.getMetaData();
    }

    @Override
    public R getPayload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.optionalExceptionResult().orElse(null));
        }
        return this.expectedResponseType.convert(this.responseMessage.getPayload());
    }

    @Override
    public Class<R> getPayloadType() {
        return this.expectedResponseType.responseMessagePayloadType();
    }

    @Override
    public QueryResponseMessage<R> withMetaData(Map<String, ?> metaData) {
        return new ConvertingResponseMessage<R>(this.expectedResponseType, (QueryResponseMessage<?>)this.responseMessage.withMetaData((Map)metaData));
    }

    @Override
    public QueryResponseMessage<R> andMetaData(Map<String, ?> additionalMetaData) {
        return new ConvertingResponseMessage<R>(this.expectedResponseType, (QueryResponseMessage<?>)this.responseMessage.andMetaData((Map)additionalMetaData));
    }
}

