/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.modelling.command.CommandHandlerInterceptor;

public class MethodCommandHandlerInterceptorDefinition
implements HandlerEnhancerDefinition {
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.annotationAttributes(CommandHandlerInterceptor.class).map(attr -> new MethodCommandHandlerInterceptorHandlingMember(original, (Map)attr)).orElse(original);
    }

    private static class MethodCommandHandlerInterceptorHandlingMember<T>
    extends WrappedMessageHandlingMember<T> {
        private final Pattern commandNamePattern;

        private MethodCommandHandlerInterceptorHandlingMember(MessageHandlingMember<T> delegate, Map<String, Object> annotationAttributes) {
            super(delegate);
            this.commandNamePattern = Pattern.compile((String)annotationAttributes.get("commandNamePattern"));
        }

        public boolean canHandle(@Nonnull Message<?> message) {
            return super.canHandle(message) && this.commandNamePattern.matcher(((CommandMessage)message).getCommandName()).matches();
        }
    }
}

