/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;

public class AssociationValuesImpl
implements AssociationValues,
Serializable {
    private static final long serialVersionUID = 8273718165811296962L;
    private final Set<AssociationValue> values = new HashSet<AssociationValue>();
    private final Set<AssociationValue> addedValues = new HashSet<AssociationValue>();
    private final Set<AssociationValue> removedValues = new HashSet<AssociationValue>();

    public AssociationValuesImpl() {
    }

    public AssociationValuesImpl(Set<AssociationValue> initialValues) {
        this.values.addAll(initialValues);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean contains(AssociationValue associationValue) {
        return this.values.contains(associationValue);
    }

    @Override
    public Iterator<AssociationValue> iterator() {
        return Collections.unmodifiableSet(this.values).iterator();
    }

    @Override
    public boolean add(AssociationValue associationValue) {
        boolean added = this.values.add(associationValue);
        if (added && !this.removedValues.remove(associationValue)) {
            this.addedValues.add(associationValue);
        }
        return added;
    }

    @Override
    public boolean remove(AssociationValue associationValue) {
        boolean removed = this.values.remove(associationValue);
        if (removed && !this.addedValues.remove(associationValue)) {
            this.removedValues.add(associationValue);
        }
        return removed;
    }

    @Override
    public Set<AssociationValue> asSet() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public Set<AssociationValue> removedAssociations() {
        if (this.removedValues.isEmpty()) {
            return Collections.emptySet();
        }
        return this.removedValues;
    }

    @Override
    public Set<AssociationValue> addedAssociations() {
        if (this.addedValues.isEmpty()) {
            return Collections.emptySet();
        }
        return this.addedValues;
    }

    @Override
    public void commit() {
        this.addedValues.clear();
        this.removedValues.clear();
    }
}

