/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoBulkWriteException;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.mongo.eventsourcing.eventstore.MongoTemplate;
import org.axonframework.mongo.eventsourcing.eventstore.StorageStrategy;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.DocumentPerEventStorageStrategy;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;

public class MongoEventStorageEngine
extends BatchingEventStorageEngine {
    private final MongoTemplate template;
    private final StorageStrategy storageStrategy;

    public MongoEventStorageEngine(MongoTemplate template) {
        this(null, null, template, new DocumentPerEventStorageStrategy());
    }

    public MongoEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, MongoTemplate template, StorageStrategy storageStrategy) {
        this(serializer, upcasterChain, null, template, storageStrategy);
    }

    public MongoEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, Integer batchSize, MongoTemplate template, StorageStrategy storageStrategy) {
        super(serializer, upcasterChain, MongoEventStorageEngine::isDuplicateKeyException, batchSize);
        this.template = template;
        this.storageStrategy = storageStrategy;
    }

    public MongoEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Integer batchSize, MongoTemplate template, StorageStrategy storageStrategy) {
        super(serializer, upcasterChain, persistenceExceptionResolver, batchSize);
        this.template = template;
        this.storageStrategy = storageStrategy;
    }

    private static boolean isDuplicateKeyException(Exception exception) {
        return exception instanceof DuplicateKeyException || exception instanceof MongoBulkWriteException && ((MongoBulkWriteException)exception).getWriteErrors().stream().anyMatch(e -> e.getCode() == 11000);
    }

    @PostConstruct
    public void ensureIndexes() {
        this.storageStrategy.ensureIndexes(this.template.eventCollection(), this.template.snapshotCollection());
    }

    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (!events.isEmpty()) {
            try {
                this.storageStrategy.appendEvents(this.template.eventCollection(), events, serializer);
            }
            catch (Exception e) {
                this.handlePersistenceException(e, events.get(0));
            }
        }
    }

    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        try {
            this.storageStrategy.appendSnapshot(this.template.snapshotCollection(), snapshot, serializer);
        }
        catch (Exception e) {
            this.handlePersistenceException(e, (EventMessage)snapshot);
        }
    }

    protected Optional<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return this.storageStrategy.findLastSnapshot(this.template.snapshotCollection(), aggregateIdentifier);
    }

    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return this.storageStrategy.findDomainEvents(this.template.eventCollection(), aggregateIdentifier, firstSequenceNumber, batchSize);
    }

    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        return this.storageStrategy.findTrackedEvents(this.template.eventCollection(), lastToken, batchSize);
    }
}

