/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.axonframework.eventsourcing.eventstore.TrackingToken;

public class MongoTrackingToken
implements TrackingToken {
    private final long timestamp;
    private final Map<String, Long> trackedEvents;

    public static MongoTrackingToken of(Instant timestamp, String eventIdentifier) {
        return new MongoTrackingToken(timestamp.toEpochMilli(), Collections.singletonMap(eventIdentifier, timestamp.toEpochMilli()));
    }

    private MongoTrackingToken(long timestamp, Map<String, Long> trackedEvents) {
        this.timestamp = timestamp;
        this.trackedEvents = trackedEvents;
    }

    public MongoTrackingToken advanceTo(Instant timestamp, String eventIdentifier, Duration lookBackTime) {
        if (this.trackedEvents.containsKey(eventIdentifier)) {
            throw new IllegalArgumentException(String.format("The event to advance to [%s] should not be one of the token's known events", eventIdentifier));
        }
        long millis = timestamp.toEpochMilli();
        LinkedHashMap<String, Long> trackedEvents = new LinkedHashMap<String, Long>(this.trackedEvents);
        trackedEvents.put(eventIdentifier, millis);
        long newTimestamp = Math.max(millis, this.timestamp);
        return new MongoTrackingToken(newTimestamp, this.trim(trackedEvents, newTimestamp, lookBackTime));
    }

    private Map<String, Long> trim(LinkedHashMap<String, Long> priorEvents, long currentTime, Duration lookBackTime) {
        Long cutOffTimestamp = currentTime - lookBackTime.toMillis();
        Iterator<Long> iterator = priorEvents.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().compareTo(cutOffTimestamp) < 0) {
                iterator.remove();
                continue;
            }
            return priorEvents;
        }
        return priorEvents;
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.timestamp);
    }

    public Set<String> getKnownEventIds() {
        return Collections.unmodifiableSet(this.trackedEvents.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoTrackingToken that = (MongoTrackingToken)o;
        return this.timestamp == that.timestamp && Objects.equals(this.trackedEvents, that.trackedEvents);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.trackedEvents);
    }

    public String toString() {
        return "MongoTrackingToken{timestamp=" + this.timestamp + ", trackedEvents=" + this.trackedEvents + '}';
    }
}

