/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.serialization;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.nio.charset.Charset;
import org.axonframework.mongo.serialization.DBObjectHierarchicalStreamReader;
import org.axonframework.mongo.serialization.DBObjectHierarchicalStreamWriter;
import org.axonframework.mongo.serialization.DBObjectToStringContentTypeConverter;
import org.axonframework.mongo.serialization.DocumentToStringContentTypeConverter;
import org.axonframework.mongo.serialization.StringToDBObjectContentTypeConverter;
import org.axonframework.serialization.AbstractXStreamSerializer;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;

public class DBObjectXStreamSerializer
extends AbstractXStreamSerializer {
    public DBObjectXStreamSerializer() {
        super(new XStream());
    }

    public DBObjectXStreamSerializer(XStream xStream) {
        super(xStream);
    }

    public DBObjectXStreamSerializer(XStream xStream, RevisionResolver revisionResolver) {
        super(xStream, revisionResolver);
    }

    public DBObjectXStreamSerializer(Charset charset) {
        super(charset, new XStream());
    }

    public DBObjectXStreamSerializer(Charset charset, XStream xStream) {
        super(charset, xStream);
    }

    public DBObjectXStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver) {
        super(charset, xStream, revisionResolver);
    }

    public DBObjectXStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver, Converter converter) {
        super(charset, xStream, revisionResolver, converter);
    }

    protected void registerConverters(ChainingConverter converter) {
        converter.registerConverter((ContentTypeConverter)new DBObjectToStringContentTypeConverter());
        converter.registerConverter((ContentTypeConverter)new DocumentToStringContentTypeConverter());
        converter.registerConverter((ContentTypeConverter)new StringToDBObjectContentTypeConverter());
    }

    protected <T> T doSerialize(Object object, Class<T> expectedFormat, XStream xStream) {
        BasicDBObject root = new BasicDBObject();
        this.getXStream().marshal(object, (HierarchicalStreamWriter)new DBObjectHierarchicalStreamWriter((DBObject)root));
        return (T)this.convert(root, DBObject.class, expectedFormat);
    }

    protected Object doDeserialize(SerializedObject serializedObject, XStream xStream) {
        DBObject serialized = (DBObject)this.convert(serializedObject.getData(), serializedObject.getContentType(), DBObject.class);
        return this.getXStream().unmarshal((HierarchicalStreamReader)new DBObjectHierarchicalStreamReader(serialized));
    }
}

