/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.axonframework.mongo.AbstractMongoTemplate;
import org.axonframework.mongo.MongoTemplate;
import org.bson.Document;

public class DefaultMongoTemplate
extends AbstractMongoTemplate
implements MongoTemplate {
    private static final String DEFAULT_TRACKINGTOKENS_COLLECTION_NAME = "trackingtokens";
    private static final String DEFAULT_DOMAINEVENTS_COLLECTION = "domainevents";
    private static final String DEFAULT_SNAPSHOTEVENTS_COLLECTION = "snapshotevents";
    private static final String DEFAULT_SAGAS_COLLECTION_NAME = "sagas";
    private final String domainEventsCollectionName;
    private final String snapshotEventsCollectionName;
    private final String trackingTokensCollectionName;
    private final String sagasCollectionName;

    public DefaultMongoTemplate(MongoClient mongo) {
        super(mongo);
        this.trackingTokensCollectionName = DEFAULT_TRACKINGTOKENS_COLLECTION_NAME;
        this.snapshotEventsCollectionName = DEFAULT_SNAPSHOTEVENTS_COLLECTION;
        this.sagasCollectionName = DEFAULT_SAGAS_COLLECTION_NAME;
        this.domainEventsCollectionName = DEFAULT_DOMAINEVENTS_COLLECTION;
    }

    public DefaultMongoTemplate(MongoClient mongo, String databaseName) {
        super(mongo, databaseName);
        this.trackingTokensCollectionName = DEFAULT_TRACKINGTOKENS_COLLECTION_NAME;
        this.snapshotEventsCollectionName = DEFAULT_SNAPSHOTEVENTS_COLLECTION;
        this.sagasCollectionName = DEFAULT_SAGAS_COLLECTION_NAME;
        this.domainEventsCollectionName = DEFAULT_DOMAINEVENTS_COLLECTION;
    }

    private DefaultMongoTemplate(MongoDatabase database, String domainEventsCollectionName, String snapshotEventsCollectionName, String sagasCollectionName, String trackingTokensCollectionName) {
        super(database);
        this.domainEventsCollectionName = domainEventsCollectionName;
        this.snapshotEventsCollectionName = snapshotEventsCollectionName;
        this.sagasCollectionName = sagasCollectionName;
        this.trackingTokensCollectionName = trackingTokensCollectionName;
    }

    public DefaultMongoTemplate withSnapshotCollection(String snapshotEventsCollectionName) {
        return new DefaultMongoTemplate(this.database(), this.domainEventsCollectionName, snapshotEventsCollectionName, this.sagasCollectionName, this.trackingTokensCollectionName);
    }

    public DefaultMongoTemplate withDomainEventsCollection(String domainEventsCollectionName) {
        return new DefaultMongoTemplate(this.database(), domainEventsCollectionName, this.snapshotEventsCollectionName, this.sagasCollectionName, this.trackingTokensCollectionName);
    }

    public DefaultMongoTemplate withSagasCollection(String sagasCollectionName) {
        return new DefaultMongoTemplate(this.database(), this.domainEventsCollectionName, this.snapshotEventsCollectionName, sagasCollectionName, this.trackingTokensCollectionName);
    }

    public DefaultMongoTemplate withTrackingTokenCollection(String trackingTokensCollectionName) {
        return new DefaultMongoTemplate(this.database(), this.domainEventsCollectionName, this.snapshotEventsCollectionName, this.sagasCollectionName, trackingTokensCollectionName);
    }

    @Override
    public MongoCollection<Document> trackingTokensCollection() {
        return this.database().getCollection(this.trackingTokensCollectionName);
    }

    @Override
    public MongoCollection<Document> eventCollection() {
        return this.database().getCollection(this.domainEventsCollectionName);
    }

    @Override
    public MongoCollection<Document> snapshotCollection() {
        return this.database().getCollection(this.snapshotEventsCollectionName);
    }

    @Override
    public MongoCollection<Document> sagaCollection() {
        return this.database().getCollection(this.sagasCollectionName);
    }
}

