/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore.documentpercommit;

import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.mongo.eventsourcing.eventstore.documentpercommit.CommitEntryConfiguration;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.EventEntry;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.serialization.Serializer;
import org.bson.Document;

public class CommitEntry {
    private final String aggregateIdentifier;
    private final String aggregateType;
    private final long firstSequenceNumber;
    private final long lastSequenceNumber;
    private final String firstTimestamp;
    private final String lastTimestamp;
    private final EventEntry[] eventEntries;
    private final String lastEventIdentifier;

    public CommitEntry(List<? extends DomainEventMessage<?>> events, Serializer serializer) {
        DomainEventMessage<?> firstEvent = events.get(0);
        DomainEventMessage<?> lastEvent = events.get(events.size() - 1);
        this.firstSequenceNumber = firstEvent.getSequenceNumber();
        this.firstTimestamp = DateTimeUtils.formatInstant((TemporalAccessor)firstEvent.getTimestamp());
        this.lastTimestamp = DateTimeUtils.formatInstant((TemporalAccessor)lastEvent.getTimestamp());
        this.lastSequenceNumber = lastEvent.getSequenceNumber();
        this.aggregateIdentifier = lastEvent.getAggregateIdentifier();
        this.lastEventIdentifier = lastEvent.getIdentifier();
        this.aggregateType = lastEvent.getType();
        this.eventEntries = new EventEntry[events.size()];
        int eventsLength = events.size();
        for (int i = 0; i < eventsLength; ++i) {
            DomainEventMessage<?> event = events.get(i);
            this.eventEntries[i] = new EventEntry(event, serializer);
        }
    }

    public CommitEntry(Document dbObject, CommitEntryConfiguration commitConfiguration, EventEntryConfiguration eventConfiguration) {
        this.aggregateIdentifier = (String)dbObject.get((Object)eventConfiguration.aggregateIdentifierProperty());
        this.firstSequenceNumber = ((Number)dbObject.get((Object)commitConfiguration.firstSequenceNumberProperty())).longValue();
        this.lastSequenceNumber = ((Number)dbObject.get((Object)commitConfiguration.lastSequenceNumberProperty())).longValue();
        this.firstTimestamp = (String)dbObject.get((Object)commitConfiguration.firstTimestampProperty());
        this.lastTimestamp = (String)dbObject.get((Object)commitConfiguration.lastTimestampProperty());
        this.aggregateType = (String)dbObject.get((Object)eventConfiguration.typeProperty());
        List entries = (List)dbObject.get((Object)commitConfiguration.eventsProperty());
        this.eventEntries = new EventEntry[entries.size()];
        this.lastEventIdentifier = (String)dbObject.get((Object)eventConfiguration.eventIdentifierProperty());
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            this.eventEntries[i] = new EventEntry((Document)entries.get(i), eventConfiguration);
        }
    }

    public EventEntry[] getEvents() {
        return this.eventEntries;
    }

    public Document asDocument(CommitEntryConfiguration commitConfiguration, EventEntryConfiguration eventConfiguration) {
        ArrayList<Document> events = new ArrayList<Document>();
        for (EventEntry eventEntry : this.eventEntries) {
            events.add(eventEntry.asDocument(eventConfiguration));
        }
        return new Document(eventConfiguration.aggregateIdentifierProperty(), (Object)this.aggregateIdentifier).append(eventConfiguration.sequenceNumberProperty(), (Object)this.lastSequenceNumber).append(eventConfiguration.eventIdentifierProperty(), (Object)this.lastEventIdentifier).append(commitConfiguration.lastSequenceNumberProperty(), (Object)this.lastSequenceNumber).append(commitConfiguration.firstSequenceNumberProperty(), (Object)this.firstSequenceNumber).append(eventConfiguration.timestampProperty(), (Object)this.firstTimestamp).append(commitConfiguration.firstTimestampProperty(), (Object)this.firstTimestamp).append(commitConfiguration.lastTimestampProperty(), (Object)this.lastTimestamp).append(eventConfiguration.typeProperty(), (Object)this.aggregateType).append(commitConfiguration.eventsProperty(), events);
    }
}

