/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.util.List;
import java.util.Optional;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.spring.config.SpringConfigurer;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaEventStoreAutoConfiguration;
import org.axonframework.springboot.autoconfig.NoOpTransactionAutoConfiguration;
import org.axonframework.springboot.autoconfig.TransactionAutoConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SpringConfigurer.class})
@AutoConfigureAfter(value={AxonAutoConfiguration.class, JpaAutoConfiguration.class, JpaEventStoreAutoConfiguration.class, NoOpTransactionAutoConfiguration.class, TransactionAutoConfiguration.class})
public class InterceptorAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public InitializingBean commandDispatchInterceptorConfigurer(CommandGateway commandGateway, Optional<List<MessageDispatchInterceptor<? super CommandMessage<?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((CommandGateway)commandGateway).registerDispatchInterceptor(arg_0)));
    }

    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public InitializingBean eventDispatchInterceptorConfigurer(EventGateway eventGateway, Optional<List<MessageDispatchInterceptor<? super EventMessage<?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((EventGateway)eventGateway).registerDispatchInterceptor(arg_0)));
    }

    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public InitializingBean queryDispatchInterceptorConfigurer(QueryGateway queryGateway, Optional<List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((QueryGateway)queryGateway).registerDispatchInterceptor(arg_0)));
    }

    @Bean
    @ConditionalOnBean(value={MessageHandlerInterceptor.class})
    public InitializingBean commandHandlerInterceptorConfigurer(CommandBus commandBus, Optional<List<MessageHandlerInterceptor<? super CommandMessage<?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((CommandBus)commandBus).registerHandlerInterceptor(arg_0)));
    }

    @Bean
    @ConditionalOnBean(value={MessageHandlerInterceptor.class})
    public InitializingBean queryHandlerInterceptorConfigurer(QueryBus queryBus, Optional<List<MessageHandlerInterceptor<? super QueryMessage<?, ?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((QueryBus)queryBus).registerHandlerInterceptor(arg_0)));
    }

    @Bean
    public InitializingBean messageHandlerInterceptorConfigurer(EventProcessingConfigurer eventProcessingConfigurer, Optional<List<MessageHandlerInterceptor<? super EventMessage<?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(i -> eventProcessingConfigurer.registerDefaultHandlerInterceptor((c, n) -> i)));
    }
}

