/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig.legacyjpa;

import java.sql.SQLException;
import java.time.temporal.TemporalAmount;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.deadletter.legacyjpa.JpaSequencedDeadLetterQueue;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.legacyjpa.JpaTokenStore;
import org.axonframework.eventsourcing.eventstore.legacyjpa.SQLErrorCodesResolver;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.legacyjpa.JpaSagaStore;
import org.axonframework.serialization.Serializer;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.TokenStoreProperties;
import org.axonframework.springboot.autoconfig.JdbcAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaAutoConfiguration;
import org.axonframework.springboot.util.DeadLetterQueueProviderConfigurerModule;
import org.axonframework.springboot.util.RegisterDefaultEntities;
import org.axonframework.springboot.util.legacyjpa.ContainerManagedEntityManagerProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@Deprecated
@AutoConfiguration
@ConditionalOnBean(value={EntityManagerFactory.class})
@EnableConfigurationProperties(value={TokenStoreProperties.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@AutoConfigureBefore(value={JpaAutoConfiguration.class, JdbcAutoConfiguration.class})
@RegisterDefaultEntities(packages={"org.axonframework.eventhandling.tokenstore.jpa", "org.axonframework.eventhandling.deadletter.jpa", "org.axonframework.modelling.saga.repository.jpa"})
public class JpaJavaxAutoConfiguration {
    private final TokenStoreProperties tokenStoreProperties;

    public JpaJavaxAutoConfiguration(TokenStoreProperties tokenStoreProperties) {
        this.tokenStoreProperties = tokenStoreProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerProvider entityManagerProvider() {
        return new ContainerManagedEntityManagerProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenStore tokenStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
        return JpaTokenStore.builder().entityManagerProvider(entityManagerProvider).serializer(serializer).claimTimeout((TemporalAmount)this.tokenStoreProperties.getClaimTimeout()).build();
    }

    @Lazy
    @Bean
    @ConditionalOnMissingBean(value={SagaStore.class})
    public JpaSagaStore sagaStore(Serializer serializer, EntityManagerProvider entityManagerProvider) {
        return JpaSagaStore.builder().entityManagerProvider(entityManagerProvider).serializer(serializer).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public PersistenceExceptionResolver persistenceExceptionResolver(DataSource dataSource) throws SQLException {
        return new SQLErrorCodesResolver(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public DeadLetterQueueProviderConfigurerModule deadLetterQueueProviderConfigurerModule(EventProcessorProperties eventProcessorProperties, EntityManagerProvider entityManagerProvider, TransactionManager transactionManager, Serializer genericSerializer, @Qualifier(value="eventSerializer") Serializer eventSerializer) {
        return new DeadLetterQueueProviderConfigurerModule(eventProcessorProperties, processingGroup -> config -> JpaSequencedDeadLetterQueue.builder().processingGroup(processingGroup).entityManagerProvider(entityManagerProvider).transactionManager(transactionManager).genericSerializer(genericSerializer).eventSerializer(eventSerializer).build());
    }
}

