/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.List;
import org.axonframework.test.matchers.ListMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ListWithAnyOfMatcher<T>
extends ListMatcher<T> {
    @SafeVarargs
    public ListWithAnyOfMatcher(Matcher<T> ... matchers) {
        super(matchers);
    }

    @Override
    public boolean matchesList(List<T> items) {
        boolean match = false;
        for (Matcher matcher : this.getMatchers()) {
            boolean matcherMatch = false;
            for (T item : items) {
                if (!matcher.matches(item)) continue;
                match = true;
                matcherMatch = true;
            }
            if (matcherMatch) continue;
            this.reportFailed(matcher);
        }
        return match;
    }

    @Override
    protected void describeCollectionType(Description description) {
        description.appendText("any");
    }

    @Override
    protected String failedMatcherMessage() {
        return "NO MATCH";
    }

    @Override
    protected String getLastSeparator() {
        return "or";
    }
}

