/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.cloudevent;

import io.cloudevents.CloudEvent;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.EventMessage;

public class MetadataUtils {
    public static final String SUBJECT = "cloud-event-subject";
    public static final String DATA_CONTENT_TYPE = "cloud-event-data-content-type";
    public static final String DATA_SCHEMA = "cloud-event-data-schema";
    private static final Set<String> RESERVED_METADATA = Stream.of("cloud-event-subject", "cloud-event-data-content-type", "cloud-event-data-schema").collect(Collectors.toCollection(HashSet::new));

    private MetadataUtils() {
    }

    public static Predicate<Map.Entry<String, Object>> reservedMetadataFilter() {
        return e -> !RESERVED_METADATA.contains(e.getKey());
    }

    public static Map<String, Object> getAdditionalEntries(CloudEvent cloudEvent) {
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        if (!Objects.isNull(cloudEvent.getSubject())) {
            metadataMap.put(SUBJECT, cloudEvent.getSubject());
        }
        if (!Objects.isNull(cloudEvent.getDataContentType())) {
            metadataMap.put(DATA_CONTENT_TYPE, cloudEvent.getDataContentType());
        }
        if (!Objects.isNull(cloudEvent.getDataSchema())) {
            metadataMap.put(DATA_SCHEMA, cloudEvent.getDataSchema());
        }
        return metadataMap;
    }

    public static Function<EventMessage<?>, Optional<String>> defaultSubjectSupplier() {
        return message -> {
            Object subject = message.getMetaData().get((Object)SUBJECT);
            if (subject instanceof String) {
                return Optional.of((String)subject);
            }
            return Optional.empty();
        };
    }

    public static Function<EventMessage<?>, Optional<String>> defaultDataContentTypeSupplier() {
        return message -> {
            Object dataContentType = message.getMetaData().get((Object)DATA_CONTENT_TYPE);
            if (dataContentType instanceof String) {
                return Optional.of((String)dataContentType);
            }
            return Optional.empty();
        };
    }

    public static Function<EventMessage<?>, Optional<URI>> defaultDataSchemaSupplier() {
        return message -> {
            Object dataSchema = message.getMetaData().get((Object)DATA_SCHEMA);
            if (dataSchema instanceof URI) {
                return Optional.of((URI)dataSchema);
            }
            return Optional.empty();
        };
    }
}

