/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer;

import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.axonframework.extensions.kafka.eventhandling.consumer.TopicSubscriber;

public class TopicListSubscriber
implements TopicSubscriber {
    private final Collection<String> topics;

    public TopicListSubscriber(Collection<String> topics) {
        this.topics = topics;
    }

    public void addTopic(String topic) {
        if (topic != null && !topic.isEmpty()) {
            this.topics.add(topic);
        }
    }

    @Override
    public void subscribeTopics(Consumer consumer) {
        consumer.subscribe(this.topics);
    }

    @Override
    public boolean subscribesToTopicName(String topic) {
        return this.topics.contains(topic);
    }

    @Override
    public String describe() {
        return "topics=[" + String.join((CharSequence)", ", this.topics) + "]";
    }
}

