/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.consumer.streamable;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.kafka.common.TopicPartition;
import org.axonframework.serialization.SerializationException;

public class TopicPartitionDeserializer
extends KeyDeserializer {
    private static final char HYPHEN = '-';

    public TopicPartition deserializeKey(String key, DeserializationContext context) {
        int position;
        if (null == key || key.lastIndexOf(45) < 1) {
            return null;
        }
        int hyphenIndex = key.lastIndexOf(45);
        String positionString = key.substring(hyphenIndex + 1);
        try {
            position = Integer.parseInt(positionString);
        }
        catch (NumberFormatException e) {
            throw new SerializationException(String.format("Cannot parse the position of TopicPartition from json:[%s].", key));
        }
        if (position < 0) {
            throw new SerializationException("The position of the TopicPartition should be greater than zero.");
        }
        return new TopicPartition(key.substring(0, hyphenIndex), position);
    }
}

