/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.kafka.eventhandling.producer;

import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.extensions.kafka.eventhandling.producer.KafkaPublisher;

public class KafkaEventPublisher<K, V>
implements EventMessageHandler {
    public static final String DEFAULT_PROCESSING_GROUP = "__axon-kafka-event-publishing-group";
    private static final boolean DOES_NOT_SUPPORT_RESET = false;
    private final String processingGroup;
    private final KafkaPublisher<K, V> kafkaPublisher;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    protected KafkaEventPublisher(Builder<K, V> builder) {
        builder.validate();
        this.processingGroup = ((Builder)builder).processingGroup;
        this.kafkaPublisher = ((Builder)builder).kafkaPublisher;
    }

    public Object handle(EventMessage<?> event) {
        this.kafkaPublisher.send(event);
        return null;
    }

    public boolean supportsReset() {
        return false;
    }

    public String getProcessingGroup() {
        return this.processingGroup;
    }

    public static class Builder<K, V> {
        private String processingGroup = "__axon-kafka-event-publishing-group";
        private KafkaPublisher<K, V> kafkaPublisher;

        public Builder<K, V> processingGroup(String processingGroup) {
            BuilderUtils.assertNonEmpty((String)processingGroup, (String)"ProcessingGroup may not be null or empty");
            this.processingGroup = processingGroup;
            return this;
        }

        public Builder<K, V> kafkaPublisher(KafkaPublisher<K, V> kafkaPublisher) {
            BuilderUtils.assertNonNull(kafkaPublisher, (String)"KafkaPublisher may not be null");
            this.kafkaPublisher = kafkaPublisher;
            return this;
        }

        public KafkaEventPublisher<K, V> build() {
            return new KafkaEventPublisher(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.kafkaPublisher, (String)"The KafkaPublisher is a hard requirement and should be provided");
        }
    }
}

