/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.AbstractCascadableParameter;
import org.biouno.unochoice.UnoChoiceParameterDescriptor;
import org.biouno.unochoice.model.Script;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class DynamicReferenceParameter
extends AbstractCascadableParameter {
    private static final long serialVersionUID = 8261526672604361397L;
    private final String choiceType;
    private final Boolean omitValueField;

    @Deprecated
    public DynamicReferenceParameter(String name, String description, Script script, String choiceType, String referencedParameters, Boolean omitValueField) {
        super(name, description, script, referencedParameters);
        this.choiceType = StringUtils.defaultIfBlank((String)choiceType, (String)"PT_SINGLE_SELECT");
        this.omitValueField = BooleanUtils.toBooleanDefaultIfNull((Boolean)omitValueField, (boolean)Boolean.FALSE);
    }

    @DataBoundConstructor
    public DynamicReferenceParameter(String name, String description, String randomName, Script script, String choiceType, String referencedParameters, Boolean omitValueField) {
        super(name, description, randomName, script, referencedParameters);
        this.choiceType = StringUtils.defaultIfBlank((String)choiceType, (String)"PT_SINGLE_SELECT");
        this.omitValueField = BooleanUtils.toBooleanDefaultIfNull((Boolean)omitValueField, (boolean)Boolean.FALSE);
    }

    @Override
    public String getChoiceType() {
        return this.choiceType;
    }

    public boolean getOmitValueField() {
        return Objects.equals(this.omitValueField, Boolean.TRUE);
    }

    @JavaScriptMethod
    public String getChoicesAsStringForUI() {
        String result = this.getChoicesAsString(this.getParameters());
        return result;
    }

    @Extension
    @Symbol(value={"activeChoiceHtml"})
    public static final class DescriptorImpl
    extends UnoChoiceParameterDescriptor {
        private AbstractProject<?, ?> project;

        public ParameterDefinition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req != null) {
                List ancestors = req.getAncestors();
                AbstractProject project = null;
                for (Ancestor ancestor : ancestors) {
                    Object object = ancestor.getObject();
                    if (!(object instanceof AbstractProject)) continue;
                    project = (AbstractProject)object;
                    break;
                }
                this.project = project;
            }
            return (ParameterDefinition)super.newInstance(req, formData);
        }

        public AbstractProject<?, ?> getProject() {
            return this.project;
        }

        public String getDisplayName() {
            return "Active Choices Reactive Reference Parameter";
        }

        public FormValidation doCheckRequired(@QueryParameter String value) {
            String strippedValue = StringUtils.strip((String)value);
            if ("".equals(strippedValue)) {
                return FormValidation.error((String)"This field is required.");
            }
            return FormValidation.ok();
        }

        public String getHelpFile() {
            return "/plugin/uno-choice/help/parameter/active-choices-dynamic-reference-parameter.html";
        }
    }
}

