/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.locks.Lock;
import org.bitcoinj.core.BitcoinSerializer;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.net.AbstractTimeoutHandler;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PeerSocketHandler
extends AbstractTimeoutHandler
implements StreamConnection {
    private static final Logger log = LoggerFactory.getLogger(PeerSocketHandler.class);
    private final MessageSerializer serializer;
    protected PeerAddress peerAddress;
    private boolean closePending = false;
    @VisibleForTesting
    protected MessageWriteTarget writeTarget = null;
    private byte[] largeReadBuffer;
    private int largeReadBufferPos;
    private BitcoinSerializer.BitcoinPacketHeader header;
    private Lock lock = Threading.lock("PeerSocketHandler");

    public PeerSocketHandler(NetworkParameters params, InetSocketAddress remoteIp) {
        Preconditions.checkNotNull((Object)params);
        this.serializer = params.getDefaultSerializer();
        this.peerAddress = new PeerAddress(params, remoteIp);
    }

    public PeerSocketHandler(NetworkParameters params, PeerAddress peerAddress) {
        Preconditions.checkNotNull((Object)params);
        this.serializer = params.getDefaultSerializer();
        this.peerAddress = (PeerAddress)Preconditions.checkNotNull((Object)peerAddress);
    }

    public ListenableFuture sendMessage(Message message) throws NotYetConnectedException {
        this.lock.lock();
        try {
            if (this.writeTarget == null) {
                throw new NotYetConnectedException();
            }
        }
        finally {
            this.lock.unlock();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serializer.serialize(message, out);
            return this.writeTarget.writeBytes(out.toByteArray());
        }
        catch (IOException e) {
            this.exceptionCaught(e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.writeTarget == null) {
                this.closePending = true;
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.writeTarget.closeConnection();
    }

    @Override
    protected void timeoutOccurred() {
        log.info("{}: Timed out", (Object)this.getAddress());
        this.close();
    }

    protected abstract void processMessage(Message var1) throws Exception;

    @Override
    public int receiveBytes(ByteBuffer buff) {
        Preconditions.checkArgument((buff.position() == 0 && buff.capacity() >= 24 ? 1 : 0) != 0);
        try {
            boolean firstMessage = true;
            while (true) {
                Message message;
                if (this.largeReadBuffer != null) {
                    Preconditions.checkState((boolean)firstMessage);
                    int bytesToGet = Math.min(buff.remaining(), this.largeReadBuffer.length - this.largeReadBufferPos);
                    buff.get(this.largeReadBuffer, this.largeReadBufferPos, bytesToGet);
                    this.largeReadBufferPos += bytesToGet;
                    if (this.largeReadBufferPos == this.largeReadBuffer.length) {
                        this.processMessage(this.serializer.deserializePayload(this.header, ByteBuffer.wrap(this.largeReadBuffer)));
                        this.largeReadBuffer = null;
                        this.header = null;
                        firstMessage = false;
                    } else {
                        return buff.position();
                    }
                }
                int preSerializePosition = buff.position();
                try {
                    message = this.serializer.deserialize(buff);
                }
                catch (BufferUnderflowException e) {
                    if (firstMessage && buff.limit() == buff.capacity()) {
                        buff.position(0);
                        try {
                            this.serializer.seekPastMagicBytes(buff);
                            this.header = this.serializer.deserializeHeader(buff);
                            this.largeReadBuffer = new byte[this.header.size];
                            this.largeReadBufferPos = buff.remaining();
                            buff.get(this.largeReadBuffer, 0, this.largeReadBufferPos);
                        }
                        catch (BufferUnderflowException e1) {
                            throw new ProtocolException("No magic bytes+header after reading " + buff.capacity() + " bytes");
                        }
                    } else {
                        buff.position(preSerializePosition);
                    }
                    return buff.position();
                }
                this.processMessage(message);
                firstMessage = false;
            }
        }
        catch (Exception e) {
            this.exceptionCaught(e);
            return -1;
        }
    }

    @Override
    public void setWriteTarget(MessageWriteTarget writeTarget) {
        Preconditions.checkArgument((writeTarget != null ? 1 : 0) != 0);
        this.lock.lock();
        boolean closeNow = false;
        try {
            Preconditions.checkArgument((this.writeTarget == null ? 1 : 0) != 0);
            closeNow = this.closePending;
            this.writeTarget = writeTarget;
        }
        finally {
            this.lock.unlock();
        }
        if (closeNow) {
            writeTarget.closeConnection();
        }
    }

    @Override
    public int getMaxMessageSize() {
        return 0x2000000;
    }

    public PeerAddress getAddress() {
        return this.peerAddress;
    }

    private void exceptionCaught(Exception e) {
        String s;
        PeerAddress addr = this.getAddress();
        String string = s = addr == null ? "?" : addr.toString();
        if (e instanceof ConnectException || e instanceof IOException) {
            log.info(s + " - " + e.getMessage());
        } else {
            log.warn(s + " - ", (Throwable)e);
            Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
            if (handler != null) {
                handler.uncaughtException(Thread.currentThread(), e);
            }
        }
        this.close();
    }
}

