/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nullable;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class LevelDBBlockStore
implements BlockStore {
    private static final byte[] CHAIN_HEAD_KEY = "chainhead".getBytes();
    private final Context context;
    private DB db;
    private final ByteBuffer buffer = ByteBuffer.allocate(96);
    private final File path;

    public LevelDBBlockStore(Context context, File directory) throws BlockStoreException {
        this(context, directory, (DBFactory)JniDBFactory.factory);
    }

    public LevelDBBlockStore(Context context, File directory, DBFactory dbFactory) throws BlockStoreException {
        this.context = context;
        this.path = directory;
        Options options = new Options();
        options.createIfMissing();
        try {
            this.tryOpen(directory, dbFactory, options);
        }
        catch (IOException e) {
            try {
                dbFactory.repair(directory, options);
                this.tryOpen(directory, dbFactory, options);
            }
            catch (IOException e1) {
                throw new BlockStoreException(e1);
            }
        }
    }

    private synchronized void tryOpen(File directory, DBFactory dbFactory, Options options) throws IOException, BlockStoreException {
        this.db = dbFactory.open(directory, options);
        this.initStoreIfNeeded();
    }

    private synchronized void initStoreIfNeeded() throws BlockStoreException {
        if (this.db.get(CHAIN_HEAD_KEY) != null) {
            return;
        }
        Block genesis = this.context.getParams().getGenesisBlock().cloneAsHeader();
        StoredBlock storedGenesis = new StoredBlock(genesis, genesis.getWork(), 0);
        this.put(storedGenesis);
        this.setChainHead(storedGenesis);
    }

    @Override
    public synchronized void put(StoredBlock block) throws BlockStoreException {
        this.buffer.clear();
        block.serializeCompact(this.buffer);
        this.db.put(block.getHeader().getHash().getBytes(), this.buffer.array());
    }

    @Override
    @Nullable
    public synchronized StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        byte[] bits = this.db.get(hash.getBytes());
        if (bits == null) {
            return null;
        }
        return StoredBlock.deserializeCompact(this.context.getParams(), ByteBuffer.wrap(bits));
    }

    @Override
    public synchronized StoredBlock getChainHead() throws BlockStoreException {
        return this.get(Sha256Hash.wrap(this.db.get(CHAIN_HEAD_KEY)));
    }

    @Override
    public synchronized void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        this.db.put(CHAIN_HEAD_KEY, chainHead.getHeader().getHash().getBytes());
    }

    @Override
    public synchronized void close() throws BlockStoreException {
        try {
            this.db.close();
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws BlockStoreException {
        try {
            try (WriteBatch batch = this.db.createWriteBatch();
                 DBIterator it = this.db.iterator();){
                it.seekToFirst();
                while (it.hasNext()) {
                    batch.delete((byte[])((Map.Entry)it.next()).getKey());
                }
                this.db.write(batch);
            }
            this.initStoreIfNeeded();
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
    }

    public synchronized void destroy() throws IOException {
        JniDBFactory.factory.destroy(this.path, new Options());
    }

    @Override
    public NetworkParameters getParams() {
        return this.context.getParams();
    }
}

