/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptPattern;

public class RedeemData {
    public final Script redeemScript;
    public final List<ECKey> keys;

    private RedeemData(List<ECKey> keys, Script redeemScript) {
        this.redeemScript = redeemScript;
        ArrayList<ECKey> sortedKeys = new ArrayList<ECKey>(keys);
        Collections.sort(sortedKeys, ECKey.PUBKEY_COMPARATOR);
        this.keys = sortedKeys;
    }

    public static RedeemData of(List<ECKey> keys, Script redeemScript) {
        return new RedeemData(keys, redeemScript);
    }

    public static RedeemData of(ECKey key, Script redeemScript) {
        Preconditions.checkArgument((ScriptPattern.isP2PKH(redeemScript) || ScriptPattern.isP2WPKH(redeemScript) || ScriptPattern.isP2PK(redeemScript) ? 1 : 0) != 0);
        return key != null ? new RedeemData(Collections.singletonList(key), redeemScript) : null;
    }

    public ECKey getFullKey() {
        for (ECKey key : this.keys) {
            if (!key.hasPrivKey()) continue;
            return key;
        }
        return null;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        helper.add("redeemScript", (Object)this.redeemScript);
        helper.add("keys", this.keys);
        return helper.toString();
    }
}

