/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.IntRangeComparator;
import org.xmlcml.euclid.RealRange;

public class IntRange
implements EuclidConstants,
Comparable<IntRange> {
    private static final Logger LOG = Logger.getLogger(IntRange.class);
    private static final Pattern CURLY_PATTERN1;
    private static final Pattern CURLY_PATTERN2;
    private static final String ANY = "*";
    public static final IntRangeComparator ASCENDING_MIN_COMPARATOR;
    protected int maxval;
    protected int minval;

    public IntRange() {
        this.minval = Integer.MAX_VALUE;
        this.maxval = Integer.MIN_VALUE;
    }

    public IntRange(int minv, int maxv) {
        this.maxval = maxv;
        this.minval = minv;
        if (this.minval > this.maxval) {
            this.minval = Integer.MAX_VALUE;
            this.maxval = Integer.MIN_VALUE;
        }
    }

    public IntRange(IntRange r) {
        this.minval = r.minval;
        this.maxval = r.maxval;
    }

    public IntRange(RealRange r) {
        this.minval = (int)Math.round(r.minval);
        this.maxval = (int)Math.round(r.maxval);
    }

    public boolean isValid() {
        return this.minval <= this.maxval;
    }

    public boolean isEqualTo(IntRange r) {
        return r != null && this.minval == r.minval && this.maxval == r.maxval && this.minval <= this.maxval;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o != null && o instanceof IntRange) {
            IntRange ir = (IntRange)o;
            equals = this.minval == ir.minval && this.maxval == ir.maxval;
        }
        return equals;
    }

    public int hashCode() {
        return 17 * this.minval + 31 * this.maxval;
    }

    public IntRange plus(IntRange r2) {
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new IntRange();
            }
            return new IntRange(r2);
        }
        IntRange temp = new IntRange();
        temp = new IntRange(Math.min(this.minval, r2.minval), Math.max(this.maxval, r2.maxval));
        return temp;
    }

    public boolean intersectsWith(IntRange r2) {
        IntRange r = this.intersectionWith(r2);
        return r != null && r.isValid();
    }

    public IntRange intersectionWith(IntRange r2) {
        if (!this.isValid() || r2 == null || !r2.isValid()) {
            return new IntRange();
        }
        int minv = Math.max(this.minval, r2.minval);
        int maxv = Math.min(this.maxval, r2.maxval);
        return new IntRange(minv, maxv);
    }

    public int getMin() {
        return this.minval;
    }

    public int getMax() {
        return this.maxval;
    }

    public int getRange() {
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        return this.maxval - this.minval;
    }

    public boolean includes(IntRange r2) {
        return r2 != null && r2.isValid() && this.includes(r2.getMin()) && this.includes(r2.getMax());
    }

    public boolean includes(int f) {
        return f >= this.minval && f <= this.maxval;
    }

    public boolean contains(int f) {
        return this.includes(f);
    }

    public void add(int x) {
        this.maxval = Math.max(this.maxval, x);
        this.minval = Math.min(this.minval, x);
    }

    public String toString() {
        return this.minval > this.maxval ? "NULL" : "(" + this.minval + "," + this.maxval + ")";
    }

    @Override
    public int compareTo(IntRange intRange) {
        if (intRange == null) {
            return -1;
        }
        if (this.minval < intRange.minval) {
            return -1;
        }
        if (this.minval > intRange.minval) {
            return 1;
        }
        if (this.maxval < intRange.maxval) {
            return -1;
        }
        if (this.maxval > intRange.maxval) {
            return 1;
        }
        return 0;
    }

    public IntRange getRangeExtendedBy(int minExtend, int maxExtend) {
        return new IntRange(this.minval - minExtend, this.maxval + maxExtend);
    }

    public boolean touches(IntRange range) {
        return range != null && (this.maxval + 1 == range.minval || range.maxval + 1 == this.minval);
    }

    public int getMidPoint() {
        return (this.minval + this.maxval) / 2;
    }

    public static IntRange parseCurlyBracketString(String token) {
        IntRange intRange = null;
        if (token != null) {
            Integer min = null;
            Integer max = null;
            token = token.replaceAll("\\s+", "");
            Matcher matcher = CURLY_PATTERN2.matcher(token);
            try {
                if (matcher.matches()) {
                    String minS = matcher.group(1);
                    String maxS = matcher.group(2);
                    min = ANY.equals(minS) ? -2147483647 : new Integer(minS);
                    max = ANY.equals(maxS) ? Integer.MAX_VALUE : new Integer(maxS);
                } else {
                    matcher = CURLY_PATTERN1.matcher(token);
                    if (matcher.matches()) {
                        String minS = matcher.group(1);
                        max = min = Integer.valueOf(ANY.equals(minS) ? -2147483647 : new Integer(minS));
                    }
                }
                intRange = new IntRange(min, max);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot parse range: " + token));
            }
        }
        return intRange;
    }

    public static List<IntRange> createIntRangeList(List<String> tokens) {
        ArrayList<IntRange> intRangeList = new ArrayList<IntRange>();
        for (String token : tokens) {
            IntRange intRange = IntRange.parseCurlyBracketString(token);
            if (intRange == null) {
                throw new RuntimeException("Cannot parse (" + token + ") as IntRange in : " + tokens);
            }
            intRangeList.add(intRange);
        }
        return intRangeList;
    }

    public static List<IntRange> joinRanges(List<IntRange> rangeList, int tolerance) {
        if (rangeList.size() <= 1) {
            return rangeList;
        }
        ArrayList<IntRange> sortedList = new ArrayList<IntRange>();
        for (IntRange range : rangeList) {
            sortedList.add(new IntRange(range));
        }
        Collections.sort(sortedList, ASCENDING_MIN_COMPARATOR);
        ArrayList<IntRange> newList = new ArrayList<IntRange>();
        IntRange currentRange = (IntRange)sortedList.get(0);
        newList.add(currentRange);
        for (int i = 1; i < sortedList.size(); ++i) {
            IntRange range = (IntRange)sortedList.get(i);
            if (currentRange.canJoin(range, tolerance)) {
                currentRange.setMax(range.getMax());
                continue;
            }
            if (range.getMin() < currentRange.getMax()) {
                throw new RuntimeException("ranges overlap: " + currentRange + " / " + range);
            }
            currentRange = range;
            newList.add(currentRange);
        }
        return newList;
    }

    public boolean canJoin(IntRange range, int tolerance) {
        return Math.abs(this.maxval - range.minval) <= tolerance;
    }

    public static List<Multiset.Entry<IntRange>> getIntRangeEntryListSortedByCount(Multiset<IntRange> intRangeSet) {
        return Lists.newArrayList(IntRange.getIntRangeEntriesSortedByCount(intRangeSet));
    }

    public static Iterable<Multiset.Entry<IntRange>> getIntRangeEntriesSortedByCount(Multiset<IntRange> intRangeSet) {
        return Multisets.copyHighestCountFirst(intRangeSet).entrySet();
    }

    public void setMax(int max) {
        if (max >= this.minval) {
            this.maxval = max;
        }
    }

    public void setMin(int min) {
        if (min <= this.maxval) {
            this.minval = min;
        }
    }

    static {
        LOG.setLevel(Level.DEBUG);
        CURLY_PATTERN1 = Pattern.compile("\\{([^,]+)\\}");
        CURLY_PATTERN2 = Pattern.compile("\\{([^,]+),([^,]+)\\}");
        ASCENDING_MIN_COMPARATOR = new IntRangeComparator();
    }
}

