/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.document.templating;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil
extends SimpleFileVisitor<Path>
implements AutoCloseable {
    public static final int BUFFER_SIZE = 4096;
    private Path source;
    private FileOutputStream fos;
    private ZipOutputStream zos;

    public static void zip(Path source, Path target) throws IOException {
        try (ZipUtil zippingVisitor = new ZipUtil(source, target);){
            Files.walkFileTree(source, zippingVisitor);
        }
    }

    public ZipUtil(Path source, Path target) throws FileNotFoundException {
        this.source = source;
        this.fos = new FileOutputStream(target.toFile());
        this.zos = new ZipOutputStream(this.fos);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!file.toFile().exists()) {
            throw new IOException("File " + file.toString() + " not found.");
        }
        Path zipEntryPath = this.source.relativize(file);
        byte[] buffer = new byte[4096];
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            int length;
            this.zos.putNextEntry(new ZipEntry(ZipUtil.normalizePath(zipEntryPath)));
            while ((length = fis.read(buffer)) > 0) {
                this.zos.write(buffer, 0, length);
            }
            this.zos.closeEntry();
        }
        return FileVisitResult.CONTINUE;
    }

    public static String normalizePath(Path path) {
        return path.toString().replaceAll("\\\\", "/");
    }

    @Override
    public void close() throws IOException {
        this.zos.close();
        this.fos.close();
    }

    public static Path unzip(String targetDirName, ZipInputStream zis) throws IOException {
        ZipEntry entry;
        Path targetDir = Files.createTempDirectory(targetDirName, new FileAttribute[0]);
        while ((entry = zis.getNextEntry()) != null) {
            byte[] data = new byte[4096];
            File target = targetDir.toFile().toPath().resolve(entry.getName()).toFile();
            target.getParentFile().mkdirs();
            boolean isDirectory = entry.isDirectory();
            if (!(isDirectory ? target.mkdirs() : target.createNewFile()) || isDirectory) continue;
            ZipUtil.writeFile(zis, data, target);
        }
        return targetDir;
    }

    private static void writeFile(ZipInputStream zis, byte[] data, File target) throws IOException {
        FileOutputStream fos = new FileOutputStream(target);
        try (BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);){
            int count;
            while ((count = zis.read(data, 0, 4096)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
        }
    }
}

