/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Pack;

class Utils {
    static final SecureRandom testRandom = new TestSecureRandom();

    Utils() {
    }

    static void validateRandom(SecureRandom secureRandom, String string) {
        if (!(secureRandom instanceof FipsSecureRandom) && !(secureRandom.getProvider() instanceof BouncyCastleFipsProvider)) {
            throw new FipsUnapprovedOperationError(string);
        }
    }

    static void validateRandom(SecureRandom secureRandom, FipsAlgorithm fipsAlgorithm, String string) {
        if (!(secureRandom instanceof FipsSecureRandom) && !(secureRandom.getProvider() instanceof BouncyCastleFipsProvider)) {
            throw new FipsUnapprovedOperationError(string, fipsAlgorithm);
        }
    }

    static void validateRandom(SecureRandom secureRandom, int n, FipsAlgorithm fipsAlgorithm, String string) {
        if (secureRandom instanceof FipsSecureRandom) {
            if (((FipsSecureRandom)secureRandom).getSecurityStrength() < n) {
                throw new FipsUnapprovedOperationError("FIPS SecureRandom security strength not as high as required for operation", fipsAlgorithm);
            }
        } else if (secureRandom.getProvider() instanceof BouncyCastleFipsProvider) {
            if (((BouncyCastleFipsProvider)secureRandom.getProvider()).getDefaultRandomSecurityStrength() < n) {
                throw new FipsUnapprovedOperationError("FIPS SecureRandom security strength not as high as required for operation", fipsAlgorithm);
            }
        } else {
            throw new FipsUnapprovedOperationError(string, fipsAlgorithm);
        }
    }

    static void validateKeyGenRandom(SecureRandom secureRandom, int n, FipsAlgorithm fipsAlgorithm) {
        Utils.validateRandom(secureRandom, n, fipsAlgorithm, "Attempt to create key with unapproved RNG");
    }

    static void validateKeyPairGenRandom(SecureRandom secureRandom, int n, FipsAlgorithm fipsAlgorithm) {
        Utils.validateRandom(secureRandom, n, fipsAlgorithm, "Attempt to create key pair with unapproved RNG");
    }

    static void checkPermission(final Permission permission) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.checkPermission(permission);
                    return null;
                }
            });
        }
    }

    static void approvedModeCheck(boolean bl, FipsAlgorithm fipsAlgorithm) {
        if (bl != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            if (bl) {
                throw new FipsUnapprovedOperationError("Attempt to use approved implementation in unapproved thread", fipsAlgorithm);
            }
            throw new FipsUnapprovedOperationError("Attempt to use unapproved implementation in approved thread", fipsAlgorithm);
        }
    }

    static int getDefaultMacSize(Algorithm algorithm, int n) {
        if (algorithm.getName().endsWith("GMAC") || algorithm.getName().endsWith("CMAC") || algorithm.getName().endsWith("GCM")) {
            return n;
        }
        return n / 2;
    }

    static KeyParameter getKeyParameter(ValidatedSymmetricKey validatedSymmetricKey) {
        return new KeyParameterImpl(validatedSymmetricKey.getKeyBytes());
    }

    static ParametersWithIV getParametersWithIV(ValidatedSymmetricKey validatedSymmetricKey, byte[] byArray) {
        return new ParametersWithIV(new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()), byArray);
    }

    static AEADParameters getAEADParameters(ValidatedSymmetricKey validatedSymmetricKey, byte[] byArray, int n) {
        return new AEADParameters(new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()), n, byArray);
    }

    public static int getAsymmetricSecurityStrength(int n) {
        if (n >= 15360) {
            return 256;
        }
        if (n >= 7680) {
            return 192;
        }
        if (n >= 3072) {
            return 128;
        }
        if (n >= 2048) {
            return 112;
        }
        if (n >= 1024) {
            return 80;
        }
        throw new FipsUnapprovedOperationError("Requested security strength unknown");
    }

    public static int getECCurveSecurityStrength(ECCurve eCCurve) {
        int n = eCCurve.getFieldSize();
        if (n >= 512) {
            return 256;
        }
        if (n >= 384) {
            return 192;
        }
        if (n >= 256) {
            return 128;
        }
        if (n >= 224) {
            return 112;
        }
        if (n >= 160) {
            return 80;
        }
        throw new FipsUnapprovedOperationError("Requested security strength unknown");
    }

    private static class TestSecureRandom
    extends SecureRandom {
        public TestSecureRandom() {
            super(new RandomSpi(), new RandomProvider());
        }

        private static class RandomProvider
        extends Provider {
            RandomProvider() {
                super("BCFIPS_TEST_RNG", 1.0, "BCFIPS Test Secure Random Provider");
            }
        }

        private static class RandomSpi
        extends SecureRandomSpi {
            private final AtomicLong counter = new AtomicLong(System.currentTimeMillis());

            private RandomSpi() {
            }

            protected void engineSetSeed(byte[] byArray) {
            }

            protected void engineNextBytes(byte[] byArray) {
                SHA256Digest sHA256Digest = new SHA256Digest();
                byte[] byArray2 = new byte[sHA256Digest.getDigestSize()];
                byte[] byArray3 = new byte[8];
                int n = 0;
                for (int i = byArray.length; i > 0; i -= byArray2.length) {
                    Pack.longToBigEndian(this.counter.getAndIncrement(), byArray3, 0);
                    sHA256Digest.update(byArray3, 0, byArray3.length);
                    sHA256Digest.doFinal(byArray2, 0);
                    if (i > byArray2.length) {
                        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    } else {
                        System.arraycopy(byArray2, 0, byArray, n, i);
                    }
                    n += byArray2.length;
                }
            }

            protected byte[] engineGenerateSeed(int n) {
                byte[] byArray = new byte[n];
                this.engineNextBytes(byArray);
                return byArray;
            }
        }
    }
}

