/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = symmetricKeyEncSessionPacket;
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
        return byArray2[0];
    }

    public PGPSessionKey getSessionKey(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
        return new PGPSessionKey(byArray2[0] & 0xFF, Arrays.copyOfRange((byte[])byArray2, (int)1, (int)byArray2.length));
    }

    public InputStream getDataStream(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey pGPSessionKey = this.getSessionKey(pBEDataDecryptorFactory);
            boolean bl = this.encData instanceof SymmetricEncIntegrityPacket;
            PGPDataDecryptor pGPDataDecryptor = pBEDataDecryptorFactory.createDataDecryptor(bl, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
            return this.getDataStream(bl, pGPDataDecryptor);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey pGPSessionKey = sessionKeyDataDecryptorFactory.getSessionKey();
            boolean bl = this.encData instanceof SymmetricEncIntegrityPacket;
            PGPDataDecryptor pGPDataDecryptor = sessionKeyDataDecryptorFactory.createDataDecryptor(bl, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
            return this.getDataStream(bl, pGPDataDecryptor);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    private InputStream getDataStream(boolean bl, PGPDataDecryptor pGPDataDecryptor) throws PGPException {
        try {
            boolean bl2;
            int n;
            int n2;
            BCPGInputStream bCPGInputStream = this.encData.getInputStream();
            bCPGInputStream.mark(pGPDataDecryptor.getBlockSize() + 2);
            this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
            if (bl) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = pGPDataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream((InputStream)this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] byArray = new byte[pGPDataDecryptor.getBlockSize()];
            for (n2 = 0; n2 != byArray.length; ++n2) {
                n = this.encStream.read();
                if (n < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                byArray[n2] = (byte)n;
            }
            n2 = this.encStream.read();
            n = this.encStream.read();
            if (n2 < 0 || n < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean bl3 = byArray[byArray.length - 2] == (byte)n2 && byArray[byArray.length - 1] == (byte)n;
            boolean bl4 = bl2 = n2 == 0 && n == 0;
            if (!bl3 && !bl2) {
                bCPGInputStream.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public int getVersion() {
        return this.keyData.getVersion();
    }

    public int getAlgorithm() {
        return this.keyData.getEncAlgorithm();
    }
}

