/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.PKIXRecipientId;

public class KeyAgreeRecipientId
extends PKIXRecipientId {
    private KeyAgreeRecipientId(X509CertificateHolderSelector baseSelector) {
        super(2, baseSelector);
    }

    public KeyAgreeRecipientId(byte[] subjectKeyId) {
        super(2, null, null, subjectKeyId);
    }

    public KeyAgreeRecipientId(X500Name issuer, BigInteger serialNumber) {
        super(2, issuer, serialNumber, null);
    }

    public KeyAgreeRecipientId(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        super(2, issuer, serialNumber, subjectKeyId);
    }

    @Override
    public X500Name getIssuer() {
        return this.baseSelector.getIssuer();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.baseSelector.getSerialNumber();
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        return this.baseSelector.getSubjectKeyIdentifier();
    }

    @Override
    public int hashCode() {
        return this.baseSelector.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof KeyAgreeRecipientId)) {
            return false;
        }
        KeyAgreeRecipientId id = (KeyAgreeRecipientId)o;
        return this.baseSelector.equals(id.baseSelector);
    }

    @Override
    public Object clone() {
        return new KeyAgreeRecipientId(this.baseSelector);
    }

    @Override
    public boolean match(Object obj) {
        if (obj instanceof KeyAgreeRecipientInformation) {
            return ((KeyAgreeRecipientInformation)obj).getRID().equals(this);
        }
        return this.baseSelector.match(obj);
    }
}

