/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsContext tlsContext, StreamCipher streamCipher, StreamCipher streamCipher2, Digest digest, Digest digest2, int n) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        boolean bl = tlsContext.isServer();
        this.context = tlsContext;
        this.encryptCipher = streamCipher;
        this.decryptCipher = streamCipher2;
        int n2 = 2 * n + digest.getDigestSize() + digest2.getDigestSize();
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsContext, n2);
        int n3 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray, n3, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n3 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter3 = new KeyParameter(byArray, n3 += digest2.getDigestSize(), n);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n3 += n, n);
        if ((n3 += n) != n2) {
            throw new TlsFatalAlert(80);
        }
        if (bl) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = streamCipher2;
            this.decryptCipher = streamCipher;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = streamCipher;
            this.decryptCipher = streamCipher2;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        this.encryptCipher.init(true, keyParameter2);
        this.decryptCipher.init(false, keyParameter);
    }

    public int getPlaintextLimit(int n) {
        return n - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.writeMac.calculateMac(l, s, byArray, n, n2);
        byte[] byArray3 = new byte[n2 + byArray2.length];
        this.encryptCipher.processBytes(byArray, n, n2, byArray3, 0);
        this.encryptCipher.processBytes(byArray2, 0, byArray2.length, byArray3, n2);
        return byArray3;
    }

    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.readMac.getSize();
        if (n2 < n3) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[n2];
        this.decryptCipher.processBytes(byArray, n, n2, byArray2, 0);
        int n4 = n2 - n3;
        byte[] byArray3 = Arrays.copyOfRange(byArray2, n4, n2);
        byte[] byArray4 = this.readMac.calculateMac(l, s, byArray2, 0, n4);
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray2, 0, n4);
    }
}

